/*
 * Decompiled with CFR 0.152.
 */
package org.encog.normalize.output;

import org.encog.normalize.input.InputField;
import org.encog.normalize.output.BasicOutputField;
import org.encog.normalize.output.RequireTwoPass;
import org.encog.persist.annotations.EGAttribute;
import org.encog.persist.annotations.EGReference;

public class OutputFieldRangeMapped
extends BasicOutputField
implements RequireTwoPass {
    @EGReference
    private InputField field;
    @EGAttribute
    private double low;
    @EGAttribute
    private double high;

    public static double calculate(double value, double min, double max, double hi, double lo) {
        return (value - min) / (max - min) * (hi - lo) + lo;
    }

    public OutputFieldRangeMapped() {
    }

    public OutputFieldRangeMapped(InputField field, double low, double high) {
        this.field = field;
        this.low = low;
        this.high = high;
    }

    @Override
    public double calculate(int subfield) {
        return (this.field.getCurrentValue() - this.field.getMin()) / (this.field.getMax() - this.field.getMin()) * (this.high - this.low) + this.low;
    }

    public InputField getField() {
        return this.field;
    }

    public double getHigh() {
        return this.high;
    }

    public double getLow() {
        return this.low;
    }

    @Override
    public int getSubfieldCount() {
        return 1;
    }

    @Override
    public void rowInit() {
    }

    public double convertBack(double data) {
        double result = ((this.field.getMin() - this.field.getMax()) * data - this.high * this.field.getMin() + this.field.getMax() * this.low) / (this.low - this.high);
        return result;
    }
}

