/*
 * Decompiled with CFR 0.152.
 */
package org.encog.parse;

import java.io.IOException;
import java.io.InputStream;
import org.encog.bot.BotError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PeekableInputStream
extends InputStream {
    public static final int INITIAL_DEPTH = 10;
    private final InputStream stream;
    private byte[] peekBytes;
    private int peekLength;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public PeekableInputStream(InputStream is) {
        this.stream = is;
        this.peekBytes = new byte[10];
        this.peekLength = 0;
    }

    public int peek() {
        return this.peek(0);
    }

    public int peek(int depth) {
        try {
            if (this.peekBytes.length <= depth) {
                byte[] temp = new byte[depth + 10];
                for (int i = 0; i < this.peekBytes.length; ++i) {
                    temp[i] = this.peekBytes[i];
                }
                this.peekBytes = temp;
            }
            if (depth >= this.peekLength) {
                int offset = this.peekLength;
                int length = depth - this.peekLength + 1;
                int lengthRead = this.stream.read(this.peekBytes, offset, length);
                if (lengthRead == -1) {
                    return -1;
                }
                this.peekLength = depth + 1;
            }
        }
        catch (IOException e) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Exception", (Throwable)e);
            }
            throw new BotError(e);
        }
        return this.peekBytes[depth];
    }

    public boolean peek(String str) {
        for (int i = 0; i < str.length(); ++i) {
            if (this.peek(i) == str.charAt(i)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int read() {
        try {
            if (this.peekLength == 0) {
                return this.stream.read();
            }
            byte result = this.peekBytes[0];
            --this.peekLength;
            for (int i = 0; i < this.peekLength; ++i) {
                this.peekBytes[i] = this.peekBytes[i + 1];
            }
            return result;
        }
        catch (IOException e) {
            throw new BotError(e);
        }
    }

    @Override
    public long skip(long count) {
        for (long count2 = count; count2 > 0L; --count2) {
            this.read();
        }
        return count;
    }
}

