/*
 * Decompiled with CFR 0.152.
 */
package org.encog.parse.tags;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.encog.parse.ParseError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Tag {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Map<String, String> attributes = new HashMap<String, String>();
    private String name = "";
    private Type type;

    public void clear() {
        this.attributes.clear();
        this.name = "";
        this.type = Type.BEGIN;
    }

    public Tag clone() {
        Tag result = new Tag();
        result.setName(this.getName());
        result.setType(this.getType());
        for (String key : this.attributes.keySet()) {
            String value = this.attributes.get(key);
            result.setAttribute(key, value);
        }
        return result;
    }

    public int getAttributeInt(String attributeId) {
        try {
            String str = this.getAttributeValue(attributeId);
            return Integer.parseInt(str);
        }
        catch (NumberFormatException e) {
            if (this.logger.isErrorEnabled()) {
                this.logger.error("Exception", (Throwable)e);
            }
            throw new ParseError(e);
        }
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public String getAttributeValue(String name) {
        return this.attributes.get(name);
    }

    public String getName() {
        return this.name;
    }

    public Type getType() {
        return this.type;
    }

    public void setAttribute(String name, String value) {
        this.attributes.put(name, value);
    }

    public void setName(String s) {
        this.name = s;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder("<");
        if (this.type == Type.END) {
            buffer.append("/");
        }
        buffer.append(this.name);
        Set<String> set = this.attributes.keySet();
        for (String key : set) {
            String value = this.attributes.get(key);
            buffer.append(' ');
            if (value == null) {
                buffer.append("\"");
                buffer.append(key);
                buffer.append("\"");
                continue;
            }
            buffer.append(key);
            buffer.append("=\"");
            buffer.append(value);
            buffer.append("\"");
        }
        buffer.append(">");
        return buffer.toString();
    }

    public static enum Type {
        BEGIN,
        END,
        COMMENT,
        CDATA;

    }
}

