/*
 * Decompiled with CFR 0.152.
 */
package org.encog.persist;

import org.encog.persist.EncogPersistedObject;

public class DirectoryEntry
implements Comparable<DirectoryEntry> {
    private final String type;
    private final String name;
    private final String description;

    public DirectoryEntry(EncogPersistedObject obj) {
        String type = obj.getClass().getSimpleName();
        if (type.equalsIgnoreCase("BasicNeuralDataSet")) {
            type = "TrainingData";
        }
        this.type = type;
        this.description = obj.getDescription();
        this.name = obj.getName();
    }

    public DirectoryEntry(String type, String name, String description) {
        this.type = type;
        this.name = name;
        this.description = description;
    }

    @Override
    public int compareTo(DirectoryEntry other) {
        if (other.getType().equals(other.getType())) {
            String c = this.getName() == null ? "" : this.getName();
            return c.compareTo(other.getName());
        }
        return this.getType().compareTo(other.getType());
    }

    public boolean equals(Object other) {
        if (!(other instanceof DirectoryEntry)) {
            return false;
        }
        return this.compareTo((DirectoryEntry)other) == 0;
    }

    public String getDescription() {
        return this.description;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public int hashCode() {
        return this.name.hashCode() + this.type.hashCode();
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("[DirectoryEntry:type=");
        result.append(this.getType());
        result.append(",name=");
        result.append(this.getName());
        result.append("]");
        return result.toString();
    }
}

