/*
 * Decompiled with CFR 0.152.
 */
package org.encog.persist;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.encog.parse.tags.read.ReadXML;
import org.encog.persist.DirectoryEntry;
import org.encog.persist.EncogCollection;
import org.encog.persist.EncogPersistedObject;
import org.encog.persist.PersistError;
import org.encog.persist.PersistReader;
import org.encog.persist.PersistWriter;
import org.encog.persist.Persistor;
import org.encog.persist.location.PersistenceLocation;
import org.encog.persist.persistors.PersistorUtil;

public class EncogMemoryCollection
implements EncogCollection {
    private PersistenceLocation location;
    private final Map<String, EncogPersistedObject> contents = new HashMap<String, EncogPersistedObject>();
    private int fileVersion;
    private String encogVersion;
    private String platform;
    private final List<DirectoryEntry> directory = new ArrayList<DirectoryEntry>();

    @Override
    public void add(String name, EncogPersistedObject obj) {
        this.contents.put(name, obj);
        obj.setCollection(this);
        obj.setName(name);
        this.buildDirectory();
    }

    @Override
    public void buildDirectory() {
        this.directory.clear();
        for (EncogPersistedObject obj : this.contents.values()) {
            DirectoryEntry entry = new DirectoryEntry(obj);
            this.directory.add(entry);
        }
    }

    @Override
    public void clear() {
        this.contents.clear();
        this.buildDirectory();
    }

    @Override
    public void delete(DirectoryEntry object) {
        this.contents.remove(object.getName());
        this.buildDirectory();
    }

    @Override
    public void delete(String key) {
        this.contents.remove(key);
        this.buildDirectory();
    }

    @Override
    public boolean exists(String key) {
        return this.contents.containsKey(key);
    }

    @Override
    public EncogPersistedObject find(DirectoryEntry entry) {
        return this.contents.get(entry.getName());
    }

    @Override
    public EncogPersistedObject find(String key) {
        return this.contents.get(key);
    }

    public Map<String, EncogPersistedObject> getContents() {
        return this.contents;
    }

    public List<DirectoryEntry> getDirectory() {
        return this.directory;
    }

    @Override
    public String getEncogVersion() {
        return this.encogVersion;
    }

    @Override
    public int getFileVersion() {
        return this.fileVersion;
    }

    @Override
    public String getPlatform() {
        return this.platform;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(PersistenceLocation location) {
        PersistReader reader = null;
        try {
            this.location = location;
            reader = new PersistReader(location);
            Map<String, String> header = reader.readHeader();
            if (header != null) {
                this.fileVersion = Integer.parseInt(header.get("fileVersion"));
                this.encogVersion = header.get("encogVersion");
                this.platform = header.get("platform");
            }
            reader.advanceObjectsCollection();
            ReadXML in = reader.getXMLInput();
            while (in.readToTag()) {
                if (in.is("Objects", false)) {
                    break;
                }
                String type = in.getTag().getName();
                String name = in.getTag().getAttributeValue("name");
                Persistor persistor = PersistorUtil.createPersistor(type);
                if (persistor == null) {
                    throw new PersistError("Do not know how to load: " + type);
                }
                EncogPersistedObject obj = persistor.load(in);
                this.contents.put(name, obj);
                obj.setCollection(this);
            }
        }
        finally {
            this.buildDirectory();
            if (reader != null) {
                reader.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(PersistenceLocation location) {
        PersistWriter writer = null;
        writer = new PersistWriter(location);
        try {
            this.location = location;
            writer.begin();
            writer.writeHeader();
            writer.beginObjects();
            for (EncogPersistedObject obj : this.contents.values()) {
                writer.writeObject(obj);
            }
            writer.endObjects();
        }
        finally {
            this.buildDirectory();
            writer.end();
            writer.close();
        }
    }

    @Override
    public void updateProperties(String name, String newName, String desc) {
        EncogPersistedObject obj = this.contents.get(name);
        obj.setName(newName);
        obj.setDescription(desc);
        this.contents.remove(name);
        this.contents.put(newName, obj);
        this.buildDirectory();
    }

    @Override
    public PersistenceLocation getLocation() {
        return this.location;
    }
}

