/*
 * Decompiled with CFR 0.152.
 */
package org.encog.persist;

import java.io.File;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.encog.Encog;
import org.encog.neural.networks.BasicNetwork;
import org.encog.persist.DirectoryEntry;
import org.encog.persist.EncogCollection;
import org.encog.persist.EncogPersistedObject;
import org.encog.persist.PersistError;
import org.encog.persist.PersistReader;
import org.encog.persist.PersistWriter;
import org.encog.persist.location.FilePersistence;
import org.encog.persist.location.PersistenceLocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EncogPersistedCollection
implements EncogCollection {
    private PersistenceLocation location;
    public static final String GENERAL_ERROR = "Malformed XML near tag: ";
    public static final String TYPE_TEXT = "TextData";
    public static final String TYPE_PROPERTY = "PropertyData";
    public static final String TYPE_BASIC_NET = "BasicNetwork";
    public static final String TYPE_BASIC_LAYER = "BasicLayer";
    public static final String TYPE_CONTEXT_LAYER = "ContextLayer";
    public static final String TYPE_RADIAL_BASIS_LAYER = "RadialBasisFunctionLayer";
    public static final String TYPE_TRAINING = "TrainingData";
    public static final String TYPE_WEIGHTED_SYNAPSE = "WeightedSynapse";
    public static final String TYPE_WEIGHTLESS_SYNAPSE = "WeightlessSynapse";
    public static final String TYPE_DIRECT_SYNAPSE = "DirectSynapse";
    public static final String TYPE_ONE2ONE_SYNAPSE = "OneToOneSynapse";
    public static final String TYPE_NORMALIZATION = "DataNormalization";
    public static final String ATTRIBUTE_NAME = "name";
    public static final String ATTRIBUTE_DESCRIPTION = "description";
    private static final Logger LOGGER = LoggerFactory.getLogger(EncogPersistedCollection.class);
    public static final String TYPE_TRAINING_CONTINUATION = "TrainingContinuation";
    public static final String TYPE_POPULATION = "BasicPopulation";
    public static final String TYPE_SVM = "SVMNetwork";
    public static final String TYPE_BINARY = "BufferedNeuralDataSet";
    public static final String TYPE_SCRIPT = "EncogScript";
    private final PersistenceLocation filePrimary;
    private PersistenceLocation fileTemp;
    private PersistWriter writer;
    private String platform = "Java";
    private int fileVersion = 1;
    private final Set<DirectoryEntry> directory = new TreeSet<DirectoryEntry>();
    private String encogVersion = Encog.getInstance().getProperties().get("encog.version");

    public static void throwError(String tag) {
        String str = GENERAL_ERROR + tag;
        if (LOGGER.isErrorEnabled()) {
            LOGGER.error(str);
        }
        throw new PersistError(str);
    }

    public EncogPersistedCollection(File file) {
        this(new FilePersistence(file));
    }

    public EncogPersistedCollection(PersistenceLocation location) {
        this.filePrimary = location;
        if (this.filePrimary instanceof FilePersistence) {
            File file = ((FilePersistence)this.filePrimary).getFile();
            String f = file.getAbsolutePath();
            int index = f.lastIndexOf(46);
            if (index != -1) {
                f = f.substring(0, index);
            }
            f = f + ".tmp";
            this.fileTemp = new FilePersistence(new File(f));
            if (this.filePrimary.exists()) {
                try {
                    this.buildDirectory();
                }
                catch (PersistError e) {
                    this.create();
                }
            } else {
                this.create();
            }
        } else {
            this.fileTemp = null;
        }
    }

    public EncogPersistedCollection(String filename) {
        this(new File(filename));
    }

    @Override
    public void add(String name, EncogPersistedObject obj) {
        if (obj instanceof BasicNetwork) {
            ((BasicNetwork)obj).getStructure().updateFlatNetwork();
        }
        obj.setName(name);
        PersistWriter writer = new PersistWriter(this.fileTemp);
        writer.begin();
        writer.writeHeader();
        writer.beginObjects();
        writer.writeObject(obj);
        writer.mergeObjects(this.filePrimary, name);
        writer.endObjects();
        writer.end();
        writer.close();
        this.mergeTemp();
        this.buildDirectory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void buildDirectory() {
        PersistReader reader = null;
        try {
            reader = new PersistReader(this.filePrimary);
            Map<String, String> header = reader.readHeader();
            if (header != null) {
                this.fileVersion = Integer.parseInt(header.get("fileVersion"));
                this.encogVersion = header.get("encogVersion");
                this.platform = header.get("platform");
            }
            Set<DirectoryEntry> d = reader.buildDirectory();
            this.directory.clear();
            this.directory.addAll(d);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    @Override
    public void clear() {
    }

    public void create() {
        PersistWriter writer = new PersistWriter(this.filePrimary);
        writer.begin();
        writer.writeHeader();
        writer.beginObjects();
        writer.endObjects();
        writer.end();
        writer.close();
        this.directory.clear();
    }

    @Override
    public void delete(DirectoryEntry d) {
        this.delete(d.getName());
    }

    public void delete(EncogPersistedObject obj) {
        this.delete(obj.getName());
    }

    @Override
    public void delete(String name) {
        PersistWriter writer = new PersistWriter(this.fileTemp);
        writer.begin();
        writer.writeHeader();
        writer.beginObjects();
        writer.mergeObjects(this.filePrimary, name);
        writer.endObjects();
        writer.end();
        writer.close();
        this.mergeTemp();
        for (DirectoryEntry d : this.directory) {
            if (!d.getName().equals(name)) continue;
            this.directory.remove(d);
            break;
        }
    }

    @Override
    public EncogPersistedObject find(DirectoryEntry d) {
        return this.find(d.getName());
    }

    @Override
    public EncogPersistedObject find(String name) {
        PersistReader reader = new PersistReader(this.filePrimary);
        EncogPersistedObject result = reader.readObject(name);
        reader.close();
        if (result != null) {
            result.setCollection(this);
        }
        return result;
    }

    @Override
    public Collection<DirectoryEntry> getDirectory() {
        return this.directory;
    }

    @Override
    public String getEncogVersion() {
        return this.encogVersion;
    }

    @Override
    public int getFileVersion() {
        return this.fileVersion;
    }

    @Override
    public String getPlatform() {
        return this.platform;
    }

    public void mergeTemp() {
        this.filePrimary.delete();
        this.fileTemp.renameTo(this.filePrimary);
    }

    @Override
    public void updateProperties(String name, String newName, String newDesc) {
        PersistWriter writer = new PersistWriter(this.fileTemp);
        writer.begin();
        writer.writeHeader();
        writer.beginObjects();
        writer.modifyObject(this.filePrimary, name, newName, newDesc);
        writer.endObjects();
        writer.end();
        writer.close();
        this.mergeTemp();
        this.buildDirectory();
    }

    @Override
    public boolean exists(String name) {
        for (DirectoryEntry dir : this.directory) {
            if (!dir.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    @Override
    public PersistenceLocation getLocation() {
        return this.location;
    }
}

