/*
 * Decompiled with CFR 0.152.
 */
package org.encog.persist.location;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.encog.persist.EncogPersistedCollection;
import org.encog.persist.PersistError;
import org.encog.persist.location.PersistenceLocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilePersistence
implements PersistenceLocation {
    private final Logger logger = LoggerFactory.getLogger(EncogPersistedCollection.class);
    private final File file;

    public FilePersistence(File file) {
        this.file = file;
    }

    @Override
    public InputStream createInputStream() {
        try {
            return new FileInputStream(this.file);
        }
        catch (IOException e) {
            if (this.logger.isErrorEnabled()) {
                this.logger.error("Exception", (Throwable)e);
            }
            throw new PersistError(e);
        }
    }

    @Override
    public OutputStream createOutputStream() {
        try {
            return new FileOutputStream(this.file);
        }
        catch (IOException e) {
            if (this.logger.isErrorEnabled()) {
                this.logger.error("Exception", (Throwable)e);
            }
            throw new PersistError(e);
        }
    }

    @Override
    public void delete() {
        if (!this.file.delete()) {
            String str = "Failed to delete: " + this.file;
            if (this.logger.isErrorEnabled()) {
                this.logger.error(str);
            }
            throw new PersistError(str);
        }
    }

    @Override
    public boolean exists() {
        return this.file.exists();
    }

    public File getFile() {
        return this.file;
    }

    @Override
    public void renameTo(PersistenceLocation toLocation) {
        if (!(toLocation instanceof FilePersistence)) {
            String str = "Can only rename from one FilePersistence location to another";
            if (this.logger.isErrorEnabled()) {
                this.logger.error("Can only rename from one FilePersistence location to another");
            }
            throw new PersistError("Can only rename from one FilePersistence location to another");
        }
        File toFile = ((FilePersistence)toLocation).getFile();
        if (!this.file.renameTo(toFile)) {
            String str = "Failure during merge, can't rename:\n" + this.file + "to: " + toFile;
            if (this.logger.isErrorEnabled()) {
                this.logger.error(str);
            }
            throw new PersistError(str);
        }
    }
}

