/*
 * Decompiled with CFR 0.152.
 */
package org.encog.persist.location;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import org.encog.EncogError;
import org.encog.persist.EncogPersistedCollection;
import org.encog.persist.PersistError;
import org.encog.persist.location.PersistenceLocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourcePersistence
implements PersistenceLocation {
    private final String resource;
    private final Logger logger = LoggerFactory.getLogger(EncogPersistedCollection.class);

    public ResourcePersistence(String resource) {
        this.resource = resource;
    }

    @Override
    public InputStream createInputStream() {
        ClassLoader loader = this.getClass().getClassLoader();
        InputStream is = loader.getResourceAsStream(this.resource);
        if (is == null) {
            String str = "Can't read resource: " + this.resource;
            if (this.logger.isErrorEnabled()) {
                this.logger.error(str);
            }
            throw new PersistError(str);
        }
        return is;
    }

    @Override
    public OutputStream createOutputStream() {
        String str = "The ResourcePersistence location does not support write operations.";
        if (this.logger.isErrorEnabled()) {
            this.logger.error("The ResourcePersistence location does not support write operations.");
        }
        throw new PersistError("The ResourcePersistence location does not support write operations.");
    }

    @Override
    public void delete() {
        String str = "The ResourcePersistence location does not support delete operations.";
        if (this.logger.isErrorEnabled()) {
            this.logger.error("The ResourcePersistence location does not support delete operations.");
        }
        throw new PersistError("The ResourcePersistence location does not support delete operations.");
    }

    @Override
    public boolean exists() {
        String str = "The ResourcePersistence location does not support exists.";
        if (this.logger.isErrorEnabled()) {
            this.logger.error("The ResourcePersistence location does not support exists.");
        }
        throw new PersistError("The ResourcePersistence location does not support exists.");
    }

    @Override
    public void renameTo(PersistenceLocation toLocation) {
        String str = "The ResourcePersistence location does not support rename operations.";
        if (this.logger.isErrorEnabled()) {
            this.logger.error("The ResourcePersistence location does not support rename operations.");
        }
        throw new PersistError("The ResourcePersistence location does not support rename operations.");
    }

    public String loadString() {
        InputStream is = null;
        try {
            String line;
            is = this.createInputStream();
            StringBuilder result = new StringBuilder();
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            while ((line = br.readLine()) != null) {
                result.append(line);
                result.append("\r\n");
            }
            String string = result.toString();
            return string;
        }
        catch (IOException e) {
            throw new PersistError(e);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e) {
                throw new EncogError(e);
            }
        }
    }
}

