/*
 * Decompiled with CFR 0.152.
 */
package org.encog.persist.persistors;

import java.util.Map;
import org.encog.neural.data.NeuralDataPair;
import org.encog.neural.data.NeuralDataSet;
import org.encog.neural.data.basic.BasicNeuralData;
import org.encog.neural.data.basic.BasicNeuralDataPair;
import org.encog.neural.data.basic.BasicNeuralDataSet;
import org.encog.parse.tags.read.ReadXML;
import org.encog.parse.tags.write.WriteXML;
import org.encog.persist.EncogPersistedObject;
import org.encog.persist.Persistor;
import org.encog.persist.persistors.PersistorUtil;
import org.encog.util.csv.CSVFormat;
import org.encog.util.csv.NumberList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicNeuralDataSetPersistor
implements Persistor {
    public static final String TAG_ITEM = "Item";
    public static final String TAG_INPUT = "Input";
    public static final String TAG_IDEAL = "Ideal";
    private BasicNeuralDataSet currentDataSet;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    private void handleItem(ReadXML in) {
        Map<String, String> properties = in.readPropertyBlock();
        BasicNeuralDataPair pair = null;
        BasicNeuralData input = new BasicNeuralData(NumberList.fromList(CSVFormat.EG_FORMAT, properties.get(TAG_INPUT)));
        if (properties.containsKey(TAG_IDEAL)) {
            BasicNeuralData ideal = new BasicNeuralData(NumberList.fromList(CSVFormat.EG_FORMAT, properties.get(TAG_IDEAL)));
            pair = new BasicNeuralDataPair(input, ideal);
        } else {
            pair = new BasicNeuralDataPair(input);
        }
        this.currentDataSet.add(pair);
    }

    @Override
    public EncogPersistedObject load(ReadXML in) {
        String name = in.getTag().getAttributes().get("name");
        String description = in.getTag().getAttributes().get("description");
        this.currentDataSet = new BasicNeuralDataSet();
        this.currentDataSet.setName(name);
        this.currentDataSet.setDescription(description);
        while (in.readToTag()) {
            if (in.is(TAG_ITEM, true)) {
                this.handleItem(in);
                continue;
            }
            if (!in.is("TrainingData", false)) continue;
            break;
        }
        return this.currentDataSet;
    }

    @Override
    public void save(EncogPersistedObject obj, WriteXML out) {
        PersistorUtil.beginEncogObject("TrainingData", out, obj, true);
        NeuralDataSet set = (NeuralDataSet)((Object)obj);
        StringBuilder builder = new StringBuilder();
        for (NeuralDataPair pair : set) {
            out.beginTag(TAG_ITEM);
            NumberList.toList(CSVFormat.EG_FORMAT, builder, pair.getInput().getData());
            out.addProperty(TAG_INPUT, builder.toString());
            if (pair.getIdeal() != null) {
                NumberList.toList(CSVFormat.EG_FORMAT, builder, pair.getIdeal().getData());
                out.addProperty(TAG_IDEAL, builder.toString());
            }
            out.endTag();
        }
        out.endTag();
    }
}

