/*
 * Decompiled with CFR 0.152.
 */
package org.encog.persist.persistors;

import org.encog.engine.network.activation.ActivationFunction;
import org.encog.neural.networks.layers.ContextLayer;
import org.encog.parse.tags.read.ReadXML;
import org.encog.parse.tags.write.WriteXML;
import org.encog.persist.EncogPersistedObject;
import org.encog.persist.Persistor;
import org.encog.persist.persistors.BasicLayerPersistor;
import org.encog.persist.persistors.PersistorUtil;
import org.encog.util.csv.CSVFormat;
import org.encog.util.csv.NumberList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContextLayerPersistor
implements Persistor {
    public final String PROPERTY_CONTEXT = "context";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public EncogPersistedObject load(ReadXML in) {
        int neuronCount = 0;
        int x = 0;
        int y = 0;
        String threshold = null;
        String context = null;
        ActivationFunction activation = null;
        String end = in.getTag().getName();
        double biasActivation = 1.0;
        while (in.readToTag()) {
            if (in.is("activation", true)) {
                in.readToTag();
                String type = in.getTag().getName();
                activation = BasicLayerPersistor.loadActivation(type, in);
                continue;
            }
            if (in.is("neurons", true)) {
                neuronCount = in.readIntToTag();
                continue;
            }
            if (in.is("x", true)) {
                x = in.readIntToTag();
                continue;
            }
            if (in.is("y", true)) {
                y = in.readIntToTag();
                continue;
            }
            if (in.is("threshold", true)) {
                threshold = in.readTextToTag();
                continue;
            }
            if (in.is("context", true)) {
                context = in.readTextToTag();
                continue;
            }
            if (in.is("biasActivation", true)) {
                biasActivation = Double.parseDouble(in.readTextToTag());
                continue;
            }
            if (!in.is(end, false)) continue;
        }
        if (neuronCount > 0) {
            ContextLayer layer = new ContextLayer(activation, neuronCount);
            if (context != null) {
                double[] t = NumberList.fromList(CSVFormat.EG_FORMAT, context);
                for (int i = 0; i < t.length; ++i) {
                    layer.getContext().setData(i, t[i]);
                }
            }
            layer.setX(x);
            layer.setY(y);
            return layer;
        }
        return null;
    }

    @Override
    public void save(EncogPersistedObject obj, WriteXML out) {
        PersistorUtil.beginEncogObject("ContextLayer", out, obj, false);
        ContextLayer layer = (ContextLayer)obj;
        out.addProperty("neurons", layer.getNeuronCount());
        out.addProperty("x", layer.getX());
        out.addProperty("y", layer.getY());
        if (layer.hasBias()) {
            StringBuilder result = new StringBuilder();
            NumberList.toList(CSVFormat.EG_FORMAT, result, layer.getBiasWeights());
            out.addProperty("threshold", result.toString());
        }
        StringBuilder ctx = new StringBuilder();
        NumberList.toList(CSVFormat.EG_FORMAT, ctx, layer.getContext().getData());
        out.addProperty("context", ctx.toString());
        out.addProperty("biasActivation", layer.getBiasActivation());
        BasicLayerPersistor.saveActivationFunction(layer.getActivationFunction(), out);
        out.endTag();
    }
}

