/*
 * Decompiled with CFR 0.152.
 */
package org.encog.persist.persistors;

import org.encog.mathutil.matrices.Matrix;
import org.encog.parse.tags.read.ReadXML;
import org.encog.parse.tags.write.WriteXML;
import org.encog.persist.EncogPersistedObject;
import org.encog.persist.PersistError;
import org.encog.persist.Persistor;
import org.encog.persist.persistors.BasicNeuralDataSetPersistor;
import org.encog.util.csv.CSVFormat;
import org.encog.util.csv.NumberList;
import org.encog.util.obj.ReflectionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PersistorUtil {
    public static final String ATTRIBUTE_MATRIX_ROWS = "rows";
    public static final String ATTRIBUTE_MATRIX_COLS = "cols";
    public static final String ROW = "row";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public static void beginEncogObject(String objectType, WriteXML out, EncogPersistedObject obj, boolean top) {
        if (top) {
            if (obj.getName() != null) {
                out.addAttribute("name", obj.getName());
            }
            if (obj.getDescription() != null) {
                out.addAttribute("description", obj.getDescription());
            } else {
                out.addAttribute("description", "");
            }
        }
        out.addAttribute("native", obj.getClass().getName());
        out.addAttribute("id", "1");
        out.beginTag(objectType);
    }

    public static Persistor createPersistor(String className) {
        Persistor persistor2;
        try {
            if (className.equals("TrainingData")) {
                return new BasicNeuralDataSetPersistor();
            }
            String name = className + "Persistor";
            Class<?> c = Class.forName("org.encog.persist.persistors." + name);
            Persistor persistor2 = (Persistor)c.newInstance();
            return persistor2;
        }
        catch (ClassNotFoundException e) {
            persistor2 = null;
        }
        catch (InstantiationException e) {
            persistor2 = null;
        }
        catch (IllegalAccessException e) {
            persistor2 = null;
        }
        if (persistor2 == null) {
            EncogPersistedObject temp;
            Class<?> clazz = ReflectionUtil.resolveEncogClass(className);
            try {
                temp = (EncogPersistedObject)clazz.newInstance();
            }
            catch (InstantiationException e) {
                throw new PersistError(e);
            }
            catch (IllegalAccessException e) {
                throw new PersistError(e);
            }
            persistor2 = temp.createPersistor();
        }
        return persistor2;
    }

    public static Matrix loadMatrix(ReadXML in) {
        int rows = in.getTag().getAttributeInt(ATTRIBUTE_MATRIX_ROWS);
        int cols = in.getTag().getAttributeInt(ATTRIBUTE_MATRIX_COLS);
        Matrix matrix = new Matrix(rows, cols);
        int row = 0;
        String end = in.getTag().getName();
        while (in.readToTag() && !in.is(end, false)) {
            if (!in.is(ROW, true)) continue;
            String str = in.readTextToTag();
            double[] d = NumberList.fromList(CSVFormat.EG_FORMAT, str);
            for (int col = 0; col < d.length; ++col) {
                matrix.set(row, col, d[col]);
            }
            ++row;
        }
        return matrix;
    }

    public static void saveMatrix(Matrix matrix, WriteXML out) {
        out.addAttribute(ATTRIBUTE_MATRIX_ROWS, "" + matrix.getRows());
        out.addAttribute(ATTRIBUTE_MATRIX_COLS, "" + matrix.getCols());
        out.beginTag("Matrix");
        for (int row = 0; row < matrix.getRows(); ++row) {
            StringBuilder builder = new StringBuilder();
            for (int col = 0; col < matrix.getCols(); ++col) {
                if (col > 0) {
                    builder.append(',');
                }
                builder.append(matrix.get(row, col));
            }
            out.beginTag(ROW);
            out.addText(builder.toString());
            out.endTag();
        }
        out.endTag();
    }

    private PersistorUtil() {
    }
}

