/*
 * Decompiled with CFR 0.152.
 */
package org.encog.persist.persistors;

import org.encog.neural.data.PropertyData;
import org.encog.parse.tags.read.ReadXML;
import org.encog.parse.tags.write.WriteXML;
import org.encog.persist.EncogPersistedObject;
import org.encog.persist.Persistor;
import org.encog.persist.persistors.PersistorUtil;

public class PropertyDataPersistor
implements Persistor {
    public static final String TAG_PROPERTIES = "properties";
    public static final String TAG_PROPERTY = "Property";
    public static final String ATTRIBUTE_NAME = "name";
    public static final String ATTRIBUTE_VALUE = "value";
    private PropertyData propertyData;

    private void handleProperties(ReadXML in) {
        while (in.readToTag()) {
            if (in.is(TAG_PROPERTY, true)) {
                this.handleProperty(in);
                continue;
            }
            if (!in.is(TAG_PROPERTIES, false)) continue;
            break;
        }
    }

    private void handleProperty(ReadXML in) {
        String name = in.getTag().getAttributeValue(ATTRIBUTE_NAME);
        String value = in.getTag().getAttributeValue(ATTRIBUTE_VALUE);
        this.propertyData.set(name, value);
    }

    @Override
    public EncogPersistedObject load(ReadXML in) {
        String name = in.getTag().getAttributes().get(ATTRIBUTE_NAME);
        String description = in.getTag().getAttributes().get("description");
        this.propertyData = new PropertyData();
        this.propertyData.setName(name);
        this.propertyData.setDescription(description);
        while (in.readToTag()) {
            if (in.is(TAG_PROPERTIES, true)) {
                this.handleProperties(in);
                continue;
            }
            if (!in.is("PropertyData", false)) continue;
            break;
        }
        return this.propertyData;
    }

    @Override
    public void save(EncogPersistedObject obj, WriteXML out) {
        PropertyData pData = (PropertyData)obj;
        PersistorUtil.beginEncogObject("PropertyData", out, obj, true);
        out.beginTag(TAG_PROPERTIES);
        for (String key : pData.getData().keySet()) {
            out.addAttribute(ATTRIBUTE_NAME, key);
            out.addAttribute(ATTRIBUTE_VALUE, pData.get(key));
            out.beginTag(TAG_PROPERTY);
            out.endTag();
        }
        out.endTag();
        out.endTag();
    }
}

