/*
 * Decompiled with CFR 0.152.
 */
package org.encog.persist.persistors;

import java.util.StringTokenizer;
import org.encog.engine.util.EngineArray;
import org.encog.mathutil.libsvm.svm_model;
import org.encog.mathutil.libsvm.svm_node;
import org.encog.mathutil.libsvm.svm_parameter;
import org.encog.neural.networks.svm.SVMNetwork;
import org.encog.parse.tags.read.ReadXML;
import org.encog.parse.tags.write.WriteXML;
import org.encog.persist.BasicPersistedObject;
import org.encog.persist.EncogPersistedObject;
import org.encog.persist.Persistor;
import org.encog.persist.persistors.PersistorUtil;

public class SVMNetworkPersistor
implements Persistor {
    public static final String[] svm_type_table = new String[]{"c_svc", "nu_svc", "one_class", "epsilon_svr", "nu_svr"};
    public static final String[] kernel_type_table = new String[]{"linear", "polynomial", "rbf", "sigmoid", "precomputed"};
    public static final String TAG_INPUT = "input";
    public static final String TAG_OUTPUT = "output";
    public static final String TAG_MODELS = "models";
    public static final String TAG_DATA = "Data";
    public static final String TAG_ROW = "Row";
    public static final String TAG_MODEL = "Model";
    public static final String TAG_TYPE_SVM = "typeSVM";
    public static final String TAG_TYPE_KERNEL = "typeKernel";
    public static final String TAG_DEGREE = "degree";
    public static final String TAG_GAMMA = "gamma";
    public static final String TAG_COEF0 = "coef0";
    public static final String TAG_NUMCLASS = "numClass";
    public static final String TAG_TOTALSV = "totalSV";
    public static final String TAG_RHO = "rho";
    public static final String TAG_LABEL = "label";
    public static final String TAG_PROB_A = "probA";
    public static final String TAG_PROB_B = "probB";
    public static final String TAG_NSV = "nSV";

    @Override
    public EncogPersistedObject load(ReadXML in) {
        BasicPersistedObject result = null;
        int input = -1;
        int output = -1;
        String name = in.getTag().getAttributes().get("name");
        String description = in.getTag().getAttributes().get("description");
        while (in.readToTag()) {
            if (in.is(TAG_INPUT, true)) {
                input = Integer.parseInt(in.readTextToTag());
                continue;
            }
            if (in.is(TAG_OUTPUT, true)) {
                output = Integer.parseInt(in.readTextToTag());
                continue;
            }
            if (in.is(TAG_MODELS, true)) {
                result = new SVMNetwork(input, output, false);
                this.handleModels(in, (SVMNetwork)result);
                continue;
            }
            if (!in.is("SVMNetwork", false)) continue;
        }
        result.setName(name);
        result.setDescription(description);
        return result;
    }

    private void handleModels(ReadXML in, SVMNetwork network) {
        int index = 0;
        while (in.readToTag()) {
            if (in.is(TAG_MODEL, true)) {
                svm_parameter param = new svm_parameter();
                svm_model model = new svm_model();
                model.param = param;
                network.getModels()[index] = model;
                this.handleModel(in, network.getModels()[index]);
                ++index;
                continue;
            }
            if (!in.is(TAG_MODELS, false)) continue;
            break;
        }
    }

    private void handleModel(ReadXML in, svm_model model) {
        while (in.readToTag()) {
            int i;
            StringTokenizer st;
            int n;
            int i2;
            if (in.is(TAG_TYPE_SVM, true)) {
                model.param.svm_type = i2 = EngineArray.findStringInArray(svm_type_table, in.readTextToTag());
                continue;
            }
            if (in.is(TAG_DEGREE, true)) {
                model.param.degree = Integer.parseInt(in.readTextToTag());
                continue;
            }
            if (in.is(TAG_GAMMA, true)) {
                model.param.gamma = Double.parseDouble(in.readTextToTag());
                continue;
            }
            if (in.is(TAG_COEF0, true)) {
                model.param.coef0 = Double.parseDouble(in.readTextToTag());
                continue;
            }
            if (in.is(TAG_NUMCLASS, true)) {
                model.nr_class = Integer.parseInt(in.readTextToTag());
                continue;
            }
            if (in.is(TAG_TOTALSV, true)) {
                model.l = Integer.parseInt(in.readTextToTag());
                continue;
            }
            if (in.is(TAG_RHO, true)) {
                n = model.nr_class * (model.nr_class - 1) / 2;
                model.rho = new double[n];
                st = new StringTokenizer(in.readTextToTag());
                for (i = 0; i < n; ++i) {
                    model.rho[i] = Double.parseDouble(st.nextToken());
                }
                continue;
            }
            if (in.is(TAG_LABEL, true)) {
                n = model.nr_class;
                model.label = new int[n];
                st = new StringTokenizer(in.readTextToTag());
                for (i = 0; i < n; ++i) {
                    model.label[i] = Integer.parseInt(st.nextToken());
                }
                continue;
            }
            if (in.is(TAG_PROB_A, true)) {
                n = model.nr_class * (model.nr_class - 1) / 2;
                model.probA = new double[n];
                st = new StringTokenizer(in.readTextToTag());
                for (i = 0; i < n; ++i) {
                    model.probA[i] = Double.parseDouble(st.nextToken());
                }
                continue;
            }
            if (in.is(TAG_PROB_B, true)) {
                n = model.nr_class * (model.nr_class - 1) / 2;
                model.probB = new double[n];
                st = new StringTokenizer(in.readTextToTag());
                for (i = 0; i < n; ++i) {
                    model.probB[i] = Double.parseDouble(st.nextToken());
                }
                continue;
            }
            if (in.is(TAG_NSV, true)) {
                n = model.nr_class;
                model.nSV = new int[n];
                st = new StringTokenizer(in.readTextToTag());
                for (i = 0; i < n; ++i) {
                    model.nSV[i] = Integer.parseInt(st.nextToken());
                }
                continue;
            }
            if (in.is(TAG_TYPE_KERNEL, true)) {
                model.param.kernel_type = i2 = EngineArray.findStringInArray(kernel_type_table, in.readTextToTag());
                continue;
            }
            if (in.is(TAG_DATA, true)) {
                this.handleData(in, model);
                continue;
            }
            if (!in.is(TAG_MODEL, false)) continue;
            break;
        }
    }

    private void handleData(ReadXML in, svm_model model) {
        int i = 0;
        int m = model.nr_class - 1;
        int l = model.l;
        model.sv_coef = new double[m][l];
        model.SV = new svm_node[l][];
        while (in.readToTag()) {
            if (in.is(TAG_ROW, true)) {
                String line = in.readTextToTag();
                StringTokenizer st = new StringTokenizer(line, " \t\n\r\f:");
                for (int k = 0; k < m; ++k) {
                    model.sv_coef[k][i] = Double.parseDouble(st.nextToken());
                }
                int n = st.countTokens() / 2;
                model.SV[i] = new svm_node[n];
                for (int j = 0; j < n; ++j) {
                    model.SV[i][j] = new svm_node();
                    model.SV[i][j].index = Integer.parseInt(st.nextToken());
                    model.SV[i][j].value = Double.parseDouble(st.nextToken());
                }
                ++i;
                continue;
            }
            if (!in.is(TAG_DATA, false)) continue;
            break;
        }
    }

    public static void saveModel(WriteXML out, svm_model model) {
        if (model != null) {
            out.beginTag(TAG_MODEL);
            svm_parameter param = model.param;
            out.addProperty(TAG_TYPE_SVM, svm_type_table[param.svm_type]);
            out.addProperty(TAG_TYPE_KERNEL, kernel_type_table[param.kernel_type]);
            if (param.kernel_type == 1) {
                out.addProperty(TAG_DEGREE, param.degree);
            }
            if (param.kernel_type == 1 || param.kernel_type == 2 || param.kernel_type == 3) {
                out.addProperty(TAG_GAMMA, param.gamma);
            }
            if (param.kernel_type == 1 || param.kernel_type == 3) {
                out.addProperty(TAG_COEF0, param.coef0);
            }
            int nr_class = model.nr_class;
            int l = model.l;
            out.addProperty(TAG_NUMCLASS, nr_class);
            out.addProperty(TAG_TOTALSV, l);
            out.addProperty(TAG_RHO, model.rho, nr_class * (nr_class - 1) / 2);
            out.addProperty(TAG_LABEL, model.label, nr_class);
            out.addProperty(TAG_PROB_A, model.probA, nr_class * (nr_class - 1) / 2);
            out.addProperty(TAG_PROB_B, model.probB, nr_class * (nr_class - 1) / 2);
            out.addProperty(TAG_NSV, model.nSV, nr_class);
            out.beginTag(TAG_DATA);
            double[][] sv_coef = model.sv_coef;
            svm_node[][] SV = model.SV;
            StringBuilder line = new StringBuilder();
            for (int i = 0; i < l; ++i) {
                line.setLength(0);
                for (int j = 0; j < nr_class - 1; ++j) {
                    line.append(sv_coef[j][i] + " ");
                }
                svm_node[] p = SV[i];
                if (param.kernel_type == 4) {
                    line.append("0:" + (int)p[0].value);
                } else {
                    for (int j = 0; j < p.length; ++j) {
                        line.append(p[j].index + ":" + p[j].value + " ");
                    }
                }
                out.addProperty(TAG_ROW, line.toString());
            }
            out.endTag();
            out.endTag();
        }
    }

    @Override
    public void save(EncogPersistedObject obj, WriteXML out) {
        PersistorUtil.beginEncogObject("SVMNetwork", out, obj, true);
        SVMNetwork net = (SVMNetwork)obj;
        out.addProperty(TAG_INPUT, net.getInputCount());
        out.addProperty(TAG_OUTPUT, net.getOutputCount());
        out.beginTag(TAG_MODELS);
        for (int i = 0; i < net.getModels().length; ++i) {
            SVMNetworkPersistor.saveModel(out, net.getModels()[i]);
        }
        out.endTag();
        out.endTag();
    }
}

