/*
 * Decompiled with CFR 0.152.
 */
package org.encog.persist.persistors.generic;

import java.lang.reflect.Field;
import java.util.Collection;
import org.encog.parse.tags.write.WriteXML;
import org.encog.persist.EncogPersistedObject;
import org.encog.persist.PersistError;
import org.encog.persist.annotations.EGAttribute;
import org.encog.persist.annotations.EGReference;
import org.encog.persist.persistors.PersistorUtil;
import org.encog.persist.persistors.generic.ObjectTagger;
import org.encog.util.obj.ReflectionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Object2XML {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    public static final String REFF_ID = "idx";
    private WriteXML out;
    private final ObjectTagger tagger = new ObjectTagger();

    public void save(EncogPersistedObject encogObject, WriteXML out) {
        this.out = out;
        try {
            PersistorUtil.beginEncogObject(encogObject.getClass().getSimpleName(), out, encogObject, true);
            this.tagger.analyze(encogObject);
            for (Field childField : ReflectionUtil.getAllFields(encogObject.getClass())) {
                if (!ReflectionUtil.shouldAccessField(childField, true)) continue;
                childField.setAccessible(true);
                Object childValue = childField.get(encogObject);
                out.beginTag(childField.getName());
                this.saveField(childValue);
                out.endTag();
            }
            out.endTag();
        }
        catch (IllegalAccessException e) {
            throw new PersistError(e);
        }
    }

    private void saveCollection(Collection<?> value) throws IllegalAccessException {
        for (Object obj : value) {
            this.saveObject(obj);
        }
    }

    private void saveField(Object fieldObject) throws IllegalAccessException {
        if (fieldObject != null) {
            if (fieldObject instanceof Collection) {
                this.saveCollection((Collection)fieldObject);
            } else if (fieldObject.getClass().isEnum()) {
                this.out.addText(fieldObject.toString());
            } else if (ReflectionUtil.isPrimitive(fieldObject) || ReflectionUtil.isSimple(fieldObject)) {
                this.out.addText(fieldObject.toString());
            } else if (fieldObject instanceof String) {
                this.out.addText(fieldObject.toString());
            } else {
                this.saveObject(fieldObject);
            }
        }
    }

    private void saveFieldReference(Object fieldObject) {
        if (this.tagger.hasReference(fieldObject)) {
            this.out.addAttribute("ref", "" + this.tagger.getReference(fieldObject));
        } else {
            this.out.addAttribute("ref", "");
        }
        this.out.beginTag(fieldObject.getClass().getSimpleName());
        this.out.endTag();
    }

    private void saveObject(Object obj) throws IllegalAccessException {
        Object childValue;
        if (obj.getClass().isArray()) {
            return;
        }
        if (this.tagger.hasReference(obj)) {
            int id = this.tagger.getReference(obj);
            this.out.addAttribute(REFF_ID, "" + id);
        }
        Collection<Field> allFields = ReflectionUtil.getAllFields(obj.getClass());
        for (Field childField : allFields) {
            childField.setAccessible(true);
            if (!ReflectionUtil.shouldAccessField(childField, false) || childField.getAnnotation(EGAttribute.class) == null) continue;
            childValue = childField.get(obj);
            this.out.addAttribute(childField.getName(), childValue.toString());
        }
        this.out.beginTag(obj.getClass().getSimpleName());
        for (Field childField : allFields) {
            childField.setAccessible(true);
            if (!ReflectionUtil.shouldAccessField(childField, false) || childField.getAnnotation(EGAttribute.class) != null) continue;
            childValue = childField.get(obj);
            this.out.beginTag(childField.getName());
            if (childField.getAnnotation(EGReference.class) != null) {
                this.saveFieldReference(childValue);
            } else {
                this.saveField(childValue);
            }
            this.out.endTag();
        }
        this.out.endTag();
    }
}

