/*
 * Decompiled with CFR 0.152.
 */
package org.encog.persist.persistors.generic;

import java.io.File;
import java.lang.reflect.Field;
import java.util.Collection;
import org.encog.EncogError;
import org.encog.parse.tags.Tag;
import org.encog.parse.tags.read.ReadXML;
import org.encog.persist.EncogPersistedObject;
import org.encog.persist.PersistError;
import org.encog.persist.persistors.generic.ObjectMapper;
import org.encog.util.obj.ReflectionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XML2Object {
    private final ObjectMapper mapper = new ObjectMapper();
    private ReadXML in;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public void load(ReadXML in, EncogPersistedObject target) {
        this.in = in;
        this.mapper.clear();
        target.setName(in.getTag().getAttributeValue("name"));
        target.setDescription(in.getTag().getAttributeValue("description"));
        this.loadActualObject(null, target);
        this.mapper.resolve();
    }

    private void loadActualObject(Field objectField, Object target) {
        try {
            for (String key : this.in.getTag().getAttributes().keySet()) {
                if (key.equals("native")) continue;
                if (key.equals("idx")) {
                    int ref = Integer.parseInt(this.in.getTag().getAttributeValue("idx"));
                    this.mapper.addObjectMapping(ref, target);
                    continue;
                }
                Field field = ReflectionUtil.findField(target.getClass(), key);
                if (field == null) continue;
                String value = this.in.getTag().getAttributeValue(key);
                this.setFieldValue(field, target, value);
            }
            while (this.in.readToTag()) {
                if (this.in.getTag().getType() == Tag.Type.BEGIN) {
                    String value;
                    String tagName = this.in.getTag().getName();
                    Field field = ReflectionUtil.findField(target.getClass(), tagName);
                    if (field == null) continue;
                    field.setAccessible(true);
                    Object currentValue = field.get(target);
                    Class<?> type = field.getType();
                    if (type.isEnum()) {
                        value = this.in.readTextToTag();
                        this.setFieldValue(field, target, value);
                        continue;
                    }
                    if (type == String.class || type.isPrimitive()) {
                        value = this.in.readTextToTag();
                        this.setFieldValue(field, target, value);
                        continue;
                    }
                    if (currentValue instanceof Collection) {
                        this.loadCollection((Collection)currentValue);
                        continue;
                    }
                    if (field.getType() == File.class) {
                        value = this.in.readTextToTag();
                        File file = new File(value);
                        field.set(target, file);
                        continue;
                    }
                    this.in.readToTag();
                    if (this.in.getTag().getType() == Tag.Type.END) continue;
                    Object nextObject = this.loadObject(field, target);
                    field.set(target, nextObject);
                    continue;
                }
                if (this.in.getTag().getType() != Tag.Type.END || !this.in.getTag().getName().equals(target.getClass().getSimpleName())) continue;
                return;
            }
        }
        catch (IllegalArgumentException e) {
            throw new EncogError(e);
        }
        catch (IllegalAccessException e) {
            throw new EncogError(e);
        }
        catch (InstantiationException e) {
            throw new EncogError(e);
        }
    }

    private void loadCollection(Collection<Object> collection) {
        try {
            while (this.in.readToTag()) {
                if (this.in.getTag().getType() == Tag.Type.BEGIN) {
                    String tagName = this.in.getTag().getName();
                    Class<?> c = ReflectionUtil.resolveEncogClass(tagName);
                    Object target = c.newInstance();
                    this.loadActualObject(null, target);
                    collection.add(target);
                    continue;
                }
                if (this.in.getTag().getType() != Tag.Type.END) continue;
                return;
            }
        }
        catch (InstantiationException e) {
            throw new EncogError(e);
        }
        catch (IllegalAccessException e) {
            throw new EncogError(e);
        }
    }

    private Object loadObject(Field objectField, Object parent) throws InstantiationException, IllegalAccessException {
        String ref = this.in.getTag().getAttributeValue("ref");
        if (ref != null) {
            int ref2 = Integer.parseInt(this.in.getTag().getAttributeValue("ref"));
            this.mapper.addFieldMapping(ref2, objectField, parent);
            this.in.readToTag();
            return null;
        }
        Class<?> c = ReflectionUtil.resolveEncogClass(this.in.getTag().getName());
        if (c == null) {
            throw new PersistError("Can't create class: " + this.in.getTag().getName());
        }
        Object obj = c.newInstance();
        this.loadActualObject(objectField, obj);
        return obj;
    }

    private void setFieldValue(Field field, Object target, String value) {
        try {
            Class<?> type = field.getType();
            if (type.isEnum()) {
                field.set(target, ReflectionUtil.resolveEnum(field, value));
            } else if (type == Long.TYPE) {
                field.setLong(target, Long.parseLong(value));
            } else if (type == Integer.TYPE) {
                field.setInt(target, Integer.parseInt(value));
            } else if (type == Short.TYPE) {
                field.setShort(target, Short.parseShort(value));
            } else if (type == Double.TYPE) {
                field.setDouble(target, Double.parseDouble(value));
            } else if (type == Float.TYPE) {
                field.setDouble(target, Float.parseFloat(value));
            } else if (type == String.class) {
                field.set(target, value);
            } else if (type == Boolean.TYPE) {
                field.setBoolean(target, value.equalsIgnoreCase("true") ? Boolean.TRUE : Boolean.FALSE);
            }
        }
        catch (IllegalAccessException e) {
            throw new PersistError("Error parsing field:" + field.getName(), e);
        }
        catch (NumberFormatException e) {
            throw new PersistError("Error on field:" + field.getName(), e);
        }
    }
}

