/*
 * Decompiled with CFR 0.152.
 */
package org.encog.solve.genetic;

import org.encog.engine.concurrency.EngineConcurrency;
import org.encog.engine.concurrency.TaskGroup;
import org.encog.neural.networks.ContextClearable;
import org.encog.solve.genetic.MateWorker;
import org.encog.solve.genetic.crossover.Crossover;
import org.encog.solve.genetic.genome.CalculateGenomeScore;
import org.encog.solve.genetic.genome.Genome;
import org.encog.solve.genetic.genome.GenomeComparator;
import org.encog.solve.genetic.mutate.Mutate;
import org.encog.solve.genetic.population.Population;
import org.encog.solve.genetic.species.Species;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeneticAlgorithm {
    private CalculateGenomeScore calculateScore;
    private GenomeComparator comparator;
    private Crossover crossover;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private double matingPopulation;
    private Mutate mutate;
    private double mutationPercent;
    private double percentToMate;
    private Population population;

    public void calculateScore(Genome g) {
        if (g.getOrganism() instanceof ContextClearable) {
            ((ContextClearable)g.getOrganism()).clearContext();
        }
        double score = this.calculateScore.calculateScore(g);
        g.setScore(score);
    }

    public CalculateGenomeScore getCalculateScore() {
        return this.calculateScore;
    }

    public GenomeComparator getComparator() {
        return this.comparator;
    }

    public Crossover getCrossover() {
        return this.crossover;
    }

    public double getMatingPopulation() {
        return this.matingPopulation;
    }

    public Mutate getMutate() {
        return this.mutate;
    }

    public double getMutationPercent() {
        return this.mutationPercent;
    }

    public double getPercentToMate() {
        return this.percentToMate;
    }

    public Population getPopulation() {
        return this.population;
    }

    public void iteration() {
        int countToMate = (int)((double)this.population.getPopulationSize() * this.getPercentToMate());
        int offspringCount = countToMate * 2;
        int offspringIndex = this.population.getPopulationSize() - offspringCount;
        int matingPopulationSize = (int)((double)this.population.getPopulationSize() * this.getMatingPopulation());
        TaskGroup group = EngineConcurrency.getInstance().createTaskGroup();
        for (int i = 0; i < countToMate; ++i) {
            Genome mother = this.population.getGenomes().get(i);
            int fatherInt = (int)(Math.random() * (double)matingPopulationSize);
            Genome father = this.population.getGenomes().get(fatherInt);
            Genome child1 = this.population.getGenomes().get(offspringIndex);
            Genome child2 = this.population.getGenomes().get(offspringIndex + 1);
            MateWorker worker = new MateWorker(mother, father, child1, child2);
            EngineConcurrency.getInstance().processTask(worker, group);
            offspringIndex += 2;
        }
        group.waitForComplete();
        this.population.sort();
    }

    public void setCalculateScore(CalculateGenomeScore calculateScore) {
        this.calculateScore = calculateScore;
    }

    public void setComparator(GenomeComparator comparator) {
        this.comparator = comparator;
    }

    public void setCrossover(Crossover crossover) {
        this.crossover = crossover;
    }

    public void setMatingPopulation(double matingPopulation) {
        this.matingPopulation = matingPopulation;
    }

    public void setMutate(Mutate mutate) {
        this.mutate = mutate;
    }

    public void setMutationPercent(double mutationPercent) {
        this.mutationPercent = mutationPercent;
    }

    public void setPercentToMate(double percentToMate) {
        this.percentToMate = percentToMate;
    }

    public void setPopulation(Population population) {
        this.population = population;
    }

    public void addSpeciesMember(Species species, Genome genome) {
        if (this.getComparator().isBetterThan(genome.getScore(), species.getBestScore())) {
            species.setBestScore(genome.getScore());
            species.setGensNoImprovement(0);
            species.setLeader(genome);
        }
        species.getMembers().add(genome);
    }
}

