/*
 * Decompiled with CFR 0.152.
 */
package org.encog.solve.genetic.genome;

import java.util.ArrayList;
import java.util.List;
import org.encog.persist.annotations.EGAttribute;
import org.encog.persist.annotations.EGIgnore;
import org.encog.solve.genetic.GeneticAlgorithm;
import org.encog.solve.genetic.GeneticError;
import org.encog.solve.genetic.genome.Chromosome;
import org.encog.solve.genetic.genome.Genome;

public abstract class BasicGenome
implements Genome {
    @EGAttribute
    private double adjustedScore;
    @EGAttribute
    private double amountToSpawn;
    private final List<Chromosome> chromosomes = new ArrayList<Chromosome>();
    @EGIgnore
    private GeneticAlgorithm geneticAlgorithm;
    @EGAttribute
    private long genomeID;
    @EGIgnore
    private Object organism;
    @EGAttribute
    private double score = 0.0;

    public BasicGenome(GeneticAlgorithm geneticAlgorithm) {
        this.geneticAlgorithm = geneticAlgorithm;
    }

    @Override
    public int calculateGeneCount() {
        int result = 0;
        for (Chromosome chromosome : this.chromosomes) {
            result += chromosome.getGenes().size();
        }
        return result;
    }

    @Override
    public int compareTo(Genome other) {
        if (this.geneticAlgorithm.getCalculateScore().shouldMinimize()) {
            if (this.getScore() > other.getScore()) {
                return 1;
            }
            return -1;
        }
        if (this.getScore() > other.getScore()) {
            return -1;
        }
        return 1;
    }

    @Override
    public double getAdjustedScore() {
        return this.adjustedScore;
    }

    @Override
    public double getAmountToSpawn() {
        return this.amountToSpawn;
    }

    @Override
    public List<Chromosome> getChromosomes() {
        return this.chromosomes;
    }

    public GeneticAlgorithm getGeneticAlgorithm() {
        return this.geneticAlgorithm;
    }

    @Override
    public long getGenomeID() {
        return this.genomeID;
    }

    @Override
    public Object getOrganism() {
        return this.organism;
    }

    @Override
    public double getScore() {
        return this.score;
    }

    @Override
    public void mate(Genome father, Genome child1, Genome child2) {
        int fatherChromosomes;
        int motherChromosomes = this.getChromosomes().size();
        if (motherChromosomes != (fatherChromosomes = father.getChromosomes().size())) {
            throw new GeneticError("Mother and father must have same chromosome count, Mother:" + motherChromosomes + ",Father:" + fatherChromosomes);
        }
        for (int i = 0; i < fatherChromosomes; ++i) {
            Chromosome motherChromosome = this.chromosomes.get(i);
            Chromosome fatherChromosome = father.getChromosomes().get(i);
            Chromosome offspring1Chromosome = child1.getChromosomes().get(i);
            Chromosome offspring2Chromosome = child2.getChromosomes().get(i);
            this.geneticAlgorithm.getCrossover().mate(motherChromosome, fatherChromosome, offspring1Chromosome, offspring2Chromosome);
            if (Math.random() < this.geneticAlgorithm.getMutationPercent()) {
                this.geneticAlgorithm.getMutate().performMutation(offspring1Chromosome);
            }
            if (!(Math.random() < this.geneticAlgorithm.getMutationPercent())) continue;
            this.geneticAlgorithm.getMutate().performMutation(offspring2Chromosome);
        }
        child1.decode();
        child2.decode();
        this.geneticAlgorithm.calculateScore(child1);
        this.geneticAlgorithm.calculateScore(child2);
    }

    @Override
    public void setAdjustedScore(double adjustedScore) {
        this.adjustedScore = adjustedScore;
    }

    @Override
    public void setAmountToSpawn(double amountToSpawn) {
        this.amountToSpawn = amountToSpawn;
    }

    public void setGeneticAlgorithm(GeneticAlgorithm ga) {
        this.geneticAlgorithm = ga;
    }

    @Override
    public void setGenomeID(long genomeID) {
        this.genomeID = genomeID;
    }

    public void setOrganism(Object organism) {
        this.organism = organism;
    }

    @Override
    public void setScore(double score) {
        this.score = score;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[BasicGenome: score=");
        builder.append(this.getScore());
        return builder.toString();
    }
}

