/*
 * Decompiled with CFR 0.152.
 */
package org.encog.solve.genetic.population;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.encog.persist.EncogCollection;
import org.encog.persist.EncogPersistedObject;
import org.encog.persist.Persistor;
import org.encog.persist.annotations.EGReferenceable;
import org.encog.persist.persistors.generic.GenericPersistor;
import org.encog.solve.genetic.genome.Genome;
import org.encog.solve.genetic.innovation.InnovationList;
import org.encog.solve.genetic.population.Population;
import org.encog.solve.genetic.species.Species;
import org.encog.util.identity.BasicGenerateID;
import org.encog.util.identity.GenerateID;

@EGReferenceable
public class BasicPopulation
implements Population,
EncogPersistedObject {
    private static final long serialVersionUID = -4097921208348173582L;
    private final GenerateID geneIDGenerate = new BasicGenerateID();
    private final GenerateID genomeIDGenerate = new BasicGenerateID();
    private final List<Genome> genomes = new ArrayList<Genome>();
    private final GenerateID innovationIDGenerate = new BasicGenerateID();
    private InnovationList innovations;
    private double oldAgePenalty = 0.3;
    private int oldAgeThreshold = 50;
    private int populationSize;
    private final List<Species> species = new ArrayList<Species>();
    private final GenerateID speciesIDGenerate = new BasicGenerateID();
    private double survivalRate = 0.2;
    private int youngBonusAgeThreshold = 10;
    private double youngScoreBonus = 0.3;
    private String name;
    private String description;
    private EncogCollection encogCollection;

    public BasicPopulation() {
        this.populationSize = 0;
    }

    public BasicPopulation(int populationSize) {
        this.populationSize = populationSize;
    }

    @Override
    public void add(Genome genome) {
        this.genomes.add(genome);
    }

    @Override
    public void addAll(List<? extends Genome> newPop) {
        this.genomes.addAll(newPop);
    }

    @Override
    public long assignGeneID() {
        return this.geneIDGenerate.generate();
    }

    @Override
    public long assignGenomeID() {
        return this.genomeIDGenerate.generate();
    }

    @Override
    public long assignInnovationID() {
        return this.innovationIDGenerate.generate();
    }

    @Override
    public long assignSpeciesID() {
        return this.speciesIDGenerate.generate();
    }

    @Override
    public void clear() {
        this.genomes.clear();
    }

    @Override
    public Persistor createPersistor() {
        return new GenericPersistor(BasicPopulation.class);
    }

    @Override
    public Genome get(int i) {
        return this.genomes.get(i);
    }

    @Override
    public Genome getBest() {
        if (this.genomes.size() == 0) {
            return null;
        }
        return this.genomes.get(0);
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public List<Genome> getGenomes() {
        return this.genomes;
    }

    @Override
    public InnovationList getInnovations() {
        return this.innovations;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public double getOldAgePenalty() {
        return this.oldAgePenalty;
    }

    @Override
    public int getOldAgeThreshold() {
        return this.oldAgeThreshold;
    }

    @Override
    public int getPopulationSize() {
        return this.populationSize;
    }

    @Override
    public List<Species> getSpecies() {
        return this.species;
    }

    @Override
    public double getSurvivalRate() {
        return this.survivalRate;
    }

    @Override
    public int getYoungBonusAgeThreshold() {
        return this.youngBonusAgeThreshold;
    }

    @Override
    public double getYoungScoreBonus() {
        return this.youngScoreBonus;
    }

    @Override
    public void setDescription(String theDescription) {
        this.description = theDescription;
    }

    @Override
    public void setInnovations(InnovationList innovations) {
        this.innovations = innovations;
    }

    @Override
    public void setName(String theName) {
        this.name = theName;
    }

    @Override
    public void setOldAgePenalty(double oldAgePenalty) {
        this.oldAgePenalty = oldAgePenalty;
    }

    @Override
    public void setOldAgeThreshold(int oldAgeThreshold) {
        this.oldAgeThreshold = oldAgeThreshold;
    }

    @Override
    public void setPopulationSize(int populationSize) {
        this.populationSize = populationSize;
    }

    @Override
    public void setSurvivalRate(double survivalRate) {
        this.survivalRate = survivalRate;
    }

    @Override
    public void setYoungBonusAgeThreshhold(int youngBonusAgeThreshold) {
        this.youngBonusAgeThreshold = youngBonusAgeThreshold;
    }

    @Override
    public void setYoungScoreBonus(double youngScoreBonus) {
        this.youngScoreBonus = youngScoreBonus;
    }

    @Override
    public int size() {
        return this.genomes.size();
    }

    @Override
    public void sort() {
        Collections.sort(this.genomes);
    }

    @Override
    public EncogCollection getCollection() {
        return this.encogCollection;
    }

    @Override
    public void setCollection(EncogCollection collection) {
        this.encogCollection = collection;
    }
}

