/*
 * Decompiled with CFR 0.152.
 */
package org.encog.util.benchmark;

import java.io.File;
import java.io.PrintStream;
import org.encog.Encog;
import org.encog.engine.StatusReportable;
import org.encog.engine.opencl.EncogCLDevice;
import org.encog.engine.util.Format;
import org.encog.neural.data.NeuralDataPair;
import org.encog.neural.data.basic.BasicNeuralDataPair;
import org.encog.neural.data.basic.BasicNeuralDataSet;
import org.encog.neural.data.buffer.BufferedNeuralDataSet;
import org.encog.util.benchmark.Evaluate;
import org.encog.util.benchmark.RandomTrainingFactory;
import org.encog.util.logging.Logging;

public class EncogBenchmark {
    private static final int STEPS = 4;
    private static final int STEP1 = 1;
    private static final int STEP2 = 2;
    private static final int STEP3 = 3;
    private static final int STEP4 = 4;
    private final StatusReportable report;
    private int cpuScore;
    private int clScore;
    private int memoryScore;
    private int binaryScore;
    private EncogCLDevice device;

    public EncogBenchmark(StatusReportable report) {
        this.report = report;
    }

    public String process() {
        Logging.stopConsoleLogging();
        this.report.report(4, 0, "Beginning benchmark");
        this.evalCPU();
        this.evalOpenCL();
        this.evalMemory();
        this.evalBinary();
        StringBuilder result = new StringBuilder();
        result.append("Encog Benchmark: CPU:");
        result.append(Format.formatInteger(this.cpuScore));
        result.append(", OpenCL");
        if (this.device == null) {
            result.append("(none)");
        } else if (this.device.isCPU()) {
            result.append("(cpu)");
        } else {
            result.append("(gpu)");
        }
        result.append(":");
        result.append(Format.formatInteger(this.clScore));
        result.append(", Memory:");
        result.append(Format.formatInteger(this.memoryScore));
        result.append(", Disk:");
        result.append(Format.formatInteger(this.binaryScore));
        this.report.report(4, 4, result.toString());
        return result.toString();
    }

    private void evalCPU() {
        int small = Evaluate.evaluateTrain(2, 4, 0, 1);
        this.report.report(4, 1, "Evaluate CPU, tiny= " + Format.formatInteger(small / 100));
        int medium = Evaluate.evaluateTrain(10, 20, 0, 1);
        this.report.report(4, 1, "Evaluate CPU, small= " + Format.formatInteger(medium / 30));
        int large = Evaluate.evaluateTrain(100, 200, 40, 5);
        this.report.report(4, 1, "Evaluate CPU, large= " + Format.formatInteger(large));
        int huge = Evaluate.evaluateTrain(200, 300, 200, 50);
        this.report.report(4, 1, "Evaluate CPU, huge= " + Format.formatInteger(huge));
        int result = small / 100 + medium / 30 + large + huge;
        this.report.report(4, 1, "CPU result: " + result);
        this.cpuScore = result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void evalOpenCL() {
        block14: {
            try {
                if (this.device != null) break block14;
                PrintStream saved = System.err;
                System.setErr(null);
                try {
                    if (Encog.getInstance().getCL() == null) {
                        Encog.getInstance().initCL();
                    }
                    this.device = Encog.getInstance().getCL().chooseDevice();
                }
                finally {
                    System.setErr(saved);
                }
            }
            catch (Throwable t) {
                this.report.report(4, 2, "No OpenCL devices, result: 0");
                this.clScore = 0;
            }
        }
        int small = 0;
        int medium = 0;
        int large = 0;
        int huge = 0;
        try {
            small = Evaluate.evaluateTrain(this.device, 2, 4, 0, 1);
            this.report.report(4, 2, "Evaluate OpenCL, tiny= " + Format.formatInteger(small / 100));
        }
        catch (Throwable t) {
            this.report.report(4, 2, "Evaluate OpenCL, tiny FAILED");
        }
        try {
            medium = Evaluate.evaluateTrain(this.device, 10, 20, 0, 1);
            this.report.report(4, 2, "Evaluate OpenCL, small= " + Format.formatInteger(medium / 30));
        }
        catch (Throwable t) {
            this.report.report(4, 2, "Evaluate OpenCL, small FAILED");
        }
        try {
            large = Evaluate.evaluateTrain(this.device, 100, 200, 40, 5);
            this.report.report(4, 2, "Evaluate OpenCL, large= " + Format.formatInteger(large));
        }
        catch (Throwable t) {
            this.report.report(4, 2, "Evaluate OpenCL, large FAILED");
        }
        try {
            huge = Evaluate.evaluateTrain(this.device, 200, 300, 200, 50);
            this.report.report(4, 2, "Evaluate OpenCL, huge= " + Format.formatInteger(huge));
        }
        catch (Throwable t) {
            this.report.report(4, 2, "Evaluate OpenCL, huge FAILED");
        }
        int result = small / 100 + medium / 30 + large + huge;
        this.report.report(4, 2, "OpenCL result: " + result);
        this.clScore = result;
    }

    private void evalMemory() {
        BasicNeuralDataSet training = RandomTrainingFactory.generate(1000L, 10000, 10, 10, -1.0, 1.0);
        long start = System.currentTimeMillis();
        long stop = start + 10000L;
        int record = 0;
        NeuralDataPair pair = BasicNeuralDataPair.createPair(10, 10);
        int iterations = 0;
        while (System.currentTimeMillis() < stop) {
            ++iterations;
            training.getRecord(record++, pair);
            if ((long)record < training.getRecordCount()) continue;
            record = 0;
        }
        this.report.report(4, 3, "Memory dataset, result: " + Format.formatInteger(iterations /= 100000));
        this.memoryScore = iterations;
    }

    private void evalBinary() {
        File file = new File("temp.egb");
        BasicNeuralDataSet training = RandomTrainingFactory.generate(1000L, 10000, 10, 10, -1.0, 1.0);
        file.delete();
        BufferedNeuralDataSet training2 = new BufferedNeuralDataSet(file);
        training2.load(training);
        long start = System.currentTimeMillis();
        long stop = start + 10000L;
        int record = 0;
        NeuralDataPair pair = BasicNeuralDataPair.createPair(10, 10);
        int iterations = 0;
        while (System.currentTimeMillis() < stop) {
            ++iterations;
            training2.getRecord(record++, pair);
            if ((long)record < training2.getRecordCount()) continue;
            record = 0;
        }
        training.close();
        this.report.report(4, 4, "Disk(binary) dataset, result: " + Format.formatInteger(iterations /= 100000));
        file.delete();
        this.binaryScore = iterations;
    }

    public int getCpuScore() {
        return this.cpuScore;
    }

    public int getClScore() {
        return this.clScore;
    }

    public int getMemoryScore() {
        return this.memoryScore;
    }

    public int getBinaryScore() {
        return this.binaryScore;
    }

    public EncogCLDevice getDevice() {
        return this.device;
    }

    public void setDevice(EncogCLDevice device) {
        this.device = device;
    }
}

