/*
 * Decompiled with CFR 0.152.
 */
package org.encog.util.csv;

import java.text.NumberFormat;
import java.util.Locale;
import org.encog.persist.annotations.EGAttribute;
import org.encog.persist.annotations.EGIgnore;
import org.encog.util.csv.CSVError;

public class CSVFormat {
    public static final CSVFormat DECIMAL_POINT = new CSVFormat('.', ',');
    public static final CSVFormat DECIMAL_COMMA = new CSVFormat(',', ';');
    public static final CSVFormat ENGLISH = DECIMAL_POINT;
    public static final CSVFormat EG_FORMAT = DECIMAL_POINT;
    @EGAttribute
    private final char decimal;
    @EGAttribute
    private final char separator;
    @EGIgnore
    private final NumberFormat numberFormatter;

    public static char getDecimalCharacter() {
        NumberFormat nf = NumberFormat.getInstance();
        String str = nf.format(0.5);
        for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            if (Character.isDigit(ch)) continue;
            return ch;
        }
        return '.';
    }

    public CSVFormat() {
        this('.', ',');
    }

    public CSVFormat(char decimal, char separator) {
        this.decimal = decimal;
        this.separator = separator;
        this.numberFormatter = decimal == '.' ? NumberFormat.getInstance(Locale.US) : (decimal == ',' ? NumberFormat.getInstance(Locale.FRANCE) : NumberFormat.getInstance());
    }

    public synchronized String format(double d, int digits) {
        this.numberFormatter.setGroupingUsed(false);
        this.numberFormatter.setMaximumFractionDigits(digits);
        return this.numberFormatter.format(d);
    }

    public char getDecimal() {
        return this.decimal;
    }

    public NumberFormat getNumberFormatter() {
        return this.numberFormatter;
    }

    public char getSeparator() {
        return this.separator;
    }

    public synchronized double parse(String str) {
        try {
            return this.numberFormatter.parse(str).doubleValue();
        }
        catch (Exception e) {
            throw new CSVError("Error:" + e.getMessage() + " on [" + str + "], decimal:" + this.decimal + ",sep: " + this.separator);
        }
    }
}

