/*
 * Decompiled with CFR 0.152.
 */
package org.encog.util.downsample;

import java.awt.Image;
import java.awt.image.PixelGrabber;
import org.encog.EncogError;
import org.encog.util.ImageSize;
import org.encog.util.downsample.Downsample;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RGBDownsample
implements Downsample {
    private int[] pixelMap;
    private double ratioX;
    private double ratioY;
    private int imageHeight;
    private int imageWidth;
    private int downSampleLeft;
    private int downSampleRight;
    private int downSampleTop;
    private int downSampleBottom;
    private int currentRed;
    private int currentBlue;
    private int currentGreen;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public double[] downSample(Image image, int height, int width) {
        this.processImage(image);
        double[] result = new double[height * width * 3];
        PixelGrabber grabber = new PixelGrabber(image, 0, 0, this.imageWidth, this.imageWidth, true);
        try {
            grabber.grabPixels();
        }
        catch (InterruptedException e) {
            if (this.logger.isErrorEnabled()) {
                this.logger.error("Exception", (Throwable)e);
            }
            throw new EncogError(e);
        }
        this.pixelMap = (int[])grabber.getPixels();
        this.ratioX = (double)(this.downSampleRight - this.downSampleLeft) / (double)width;
        this.ratioY = (double)(this.downSampleBottom - this.downSampleTop) / (double)height;
        int index = 0;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                this.downSampleRegion(x, y);
                result[index++] = this.currentRed;
                result[index++] = this.currentGreen;
                result[index++] = this.currentBlue;
            }
        }
        return result;
    }

    public void downSampleRegion(int x, int y) {
        int startX = (int)((double)this.downSampleLeft + (double)x * this.ratioX);
        int startY = (int)((double)this.downSampleTop + (double)y * this.ratioY);
        int endX = (int)((double)startX + this.ratioX);
        int endY = (int)((double)startY + this.ratioY);
        endX = Math.min(this.imageWidth, endX);
        endY = Math.min(this.imageHeight, endY);
        int redTotal = 0;
        int greenTotal = 0;
        int blueTotal = 0;
        int total = 0;
        for (int yy = startY; yy < endY; ++yy) {
            for (int xx = startX; xx < endX; ++xx) {
                int loc = xx + yy * this.imageWidth;
                int pixel = this.pixelMap[loc];
                int red = pixel >> 16 & 0xFF;
                int green = pixel >> 8 & 0xFF;
                int blue = pixel & 0xFF;
                redTotal += red;
                greenTotal += green;
                blueTotal += blue;
                ++total;
            }
        }
        this.currentRed = redTotal / total;
        this.currentGreen = greenTotal / total;
        this.currentBlue = blueTotal / total;
    }

    @Override
    public void findBounds() {
        int x;
        int y;
        for (y = 0; y < this.imageHeight; ++y) {
            if (this.hLineClear(y)) continue;
            this.downSampleTop = y;
            break;
        }
        for (y = this.imageHeight - 1; y >= 0; --y) {
            if (this.hLineClear(y)) continue;
            this.downSampleBottom = y;
            break;
        }
        for (x = 0; x < this.imageWidth; ++x) {
            if (this.vLineClear(x)) continue;
            this.downSampleLeft = x;
            break;
        }
        for (x = this.imageWidth - 1; x >= 0; --x) {
            if (this.vLineClear(x)) continue;
            this.downSampleRight = x;
            break;
        }
    }

    public int getCurrentBlue() {
        return this.currentBlue;
    }

    public int getCurrentGreen() {
        return this.currentGreen;
    }

    public int getCurrentRed() {
        return this.currentRed;
    }

    @Override
    public int getDownSampleBottom() {
        return this.downSampleBottom;
    }

    @Override
    public int getDownSampleLeft() {
        return this.downSampleLeft;
    }

    @Override
    public int getDownSampleRight() {
        return this.downSampleRight;
    }

    @Override
    public int getDownSampleTop() {
        return this.downSampleTop;
    }

    @Override
    public int getImageHeight() {
        return this.imageHeight;
    }

    @Override
    public int getImageWidth() {
        return this.imageWidth;
    }

    @Override
    public int[] getPixelMap() {
        return this.pixelMap;
    }

    @Override
    public double getRatioX() {
        return this.ratioX;
    }

    @Override
    public double getRatioY() {
        return this.ratioY;
    }

    private boolean hLineClear(int y) {
        for (int i = 0; i < this.imageWidth; ++i) {
            if (this.pixelMap[y * this.imageWidth + i] == -1) continue;
            return false;
        }
        return true;
    }

    @Override
    public void processImage(Image image) {
        ImageSize size = new ImageSize(image);
        this.imageHeight = size.getHeight();
        this.imageWidth = size.getWidth();
        this.downSampleLeft = 0;
        this.downSampleTop = 0;
        this.downSampleRight = this.imageWidth;
        this.downSampleBottom = this.imageHeight;
        this.ratioX = (double)(this.downSampleRight - this.downSampleLeft) / (double)this.getImageWidth();
        this.ratioY = (double)(this.downSampleBottom - this.downSampleTop) / (double)this.getImageHeight();
    }

    public void setCurrentBlue(int currentBlue) {
        this.currentBlue = currentBlue;
    }

    public void setCurrentGreen(int currentGreen) {
        this.currentGreen = currentGreen;
    }

    public void setCurrentRed(int currentRed) {
        this.currentRed = currentRed;
    }

    public void setPixelMap(int[] pixelMap) {
        this.pixelMap = pixelMap;
    }

    private boolean vLineClear(int x) {
        for (int i = 0; i < this.imageHeight; ++i) {
            if (this.pixelMap[i * this.imageWidth + x] == -1) continue;
            return false;
        }
        return true;
    }
}

