/*
 * Decompiled with CFR 0.152.
 */
package org.encog.util.downsample;

import java.awt.Image;
import java.awt.image.PixelGrabber;
import org.encog.EncogError;
import org.encog.util.downsample.RGBDownsample;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleIntensityDownsample
extends RGBDownsample {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public double[] downSample(Image image, int height, int width) {
        this.processImage(image);
        double[] result = new double[height * width * 3];
        PixelGrabber grabber = new PixelGrabber(image, 0, 0, this.getImageWidth(), this.getImageHeight(), true);
        try {
            grabber.grabPixels();
        }
        catch (InterruptedException e) {
            if (this.logger.isErrorEnabled()) {
                this.logger.error("Exception", (Throwable)e);
            }
            throw new EncogError(e);
        }
        this.setPixelMap((int[])grabber.getPixels());
        int index = 0;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                this.downSampleRegion(x, y);
                result[index++] = (this.getCurrentRed() + this.getCurrentBlue() + this.getCurrentGreen()) / 3;
            }
        }
        return result;
    }
}

