/*
 * Decompiled with CFR 0.152.
 */
package org.encog.app.analyst.commands;

import java.io.File;
import org.encog.app.analyst.EncogAnalyst;
import org.encog.app.analyst.commands.Cmd;
import org.encog.app.analyst.csv.shuffle.ShuffleCSV;
import org.encog.app.analyst.util.AnalystReportBridge;
import org.encog.util.csv.CSVFormat;
import org.encog.util.logging.EncogLogging;

public class CmdRandomize
extends Cmd {
    public static final String COMMAND_NAME = "RANDOMIZE";

    public CmdRandomize(EncogAnalyst analyst) {
        super(analyst);
    }

    @Override
    public final boolean executeCommand(String args) {
        String sourceID = this.getProp().getPropertyString("RANDOMIZE:CONFIG_sourceFile");
        String targetID = this.getProp().getPropertyString("RANDOMIZE:CONFIG_targetFile");
        EncogLogging.log(0, "Beginning randomize");
        EncogLogging.log(0, "source file:" + sourceID);
        EncogLogging.log(0, "target file:" + targetID);
        File sourceFile = this.getScript().resolveFilename(sourceID);
        File targetFile = this.getScript().resolveFilename(targetID);
        CSVFormat inputFormat = this.getScript().determineInputFormat(sourceID);
        CSVFormat outputFormat = this.getScript().determineOutputFormat();
        this.getScript().markGenerated(targetID);
        ShuffleCSV norm = new ShuffleCSV();
        norm.setScript(this.getScript());
        this.getAnalyst().setCurrentQuantTask(norm);
        norm.setReport(new AnalystReportBridge(this.getAnalyst()));
        boolean headers = this.getScript().expectInputHeaders(sourceID);
        norm.analyze(sourceFile, headers, inputFormat);
        norm.setOutputFormat(outputFormat);
        norm.process(targetFile);
        this.getAnalyst().setCurrentQuantTask(null);
        return norm.shouldStop();
    }

    @Override
    public final String getName() {
        return COMMAND_NAME;
    }
}

