/*
 * Decompiled with CFR 0.152.
 */
package org.encog.app.analyst.script.normalize;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.encog.app.analyst.AnalystError;
import org.encog.app.analyst.EncogAnalyst;
import org.encog.app.analyst.csv.basic.BasicFile;
import org.encog.app.analyst.script.AnalystClassItem;
import org.encog.app.analyst.script.DataField;
import org.encog.app.analyst.util.CSVHeaders;
import org.encog.app.quant.QuantError;
import org.encog.mathutil.Equilateral;
import org.encog.util.EngineArray;
import org.encog.util.arrayutil.ClassItem;
import org.encog.util.arrayutil.NormalizationAction;
import org.encog.util.csv.CSVFormat;

public class AnalystField {
    public static final int MIN_EQ_CLASSES = 3;
    private double actualHigh;
    private double actualLow;
    private double normalizedHigh;
    private double normalizedLow;
    private NormalizationAction action;
    private String name;
    private final List<ClassItem> classes = new ArrayList<ClassItem>();
    private Equilateral eq;
    private final Map<String, Integer> lookup = new HashMap<String, Integer>();
    private boolean output;
    private int timeSlice;

    public AnalystField() {
        this(1.0, -1.0);
    }

    public AnalystField(AnalystField field) {
        this.actualHigh = field.actualHigh;
        this.actualLow = field.actualLow;
        this.normalizedHigh = field.normalizedHigh;
        this.normalizedLow = field.normalizedLow;
        this.action = field.action;
        this.name = field.name;
        this.output = field.output;
        this.timeSlice = field.timeSlice;
    }

    public AnalystField(double theNormalizedHigh, double theNormalizedLow) {
        this.normalizedHigh = theNormalizedHigh;
        this.normalizedLow = theNormalizedLow;
        this.actualHigh = Double.MIN_VALUE;
        this.actualLow = Double.MAX_VALUE;
        this.action = NormalizationAction.Normalize;
    }

    public AnalystField(NormalizationAction theAction, String theName) {
        this(theAction, theName, 0.0, 0.0, 0.0, 0.0);
    }

    public AnalystField(NormalizationAction theAction, String theName, double ahigh, double alow, double nhigh, double nlow) {
        this.action = theAction;
        this.actualHigh = ahigh;
        this.actualLow = alow;
        this.normalizedHigh = nhigh;
        this.normalizedLow = nlow;
        this.name = theName;
    }

    public AnalystField(String theName, NormalizationAction theAction, double high, double low) {
        this.name = theName;
        this.action = theAction;
        this.normalizedHigh = high;
        this.normalizedLow = low;
    }

    public final void addRawHeadings(StringBuilder line, String prefix, CSVFormat format) {
        int subFields = this.getColumnsNeeded();
        for (int i = 0; i < subFields; ++i) {
            String str = CSVHeaders.tagColumn(this.name, i, this.timeSlice, subFields > 1);
            BasicFile.appendSeparator(line, format);
            line.append('\"');
            if (prefix != null) {
                line.append(prefix);
            }
            line.append(str);
            line.append('\"');
        }
    }

    public final void analyze(double d) {
        this.actualHigh = Math.max(this.actualHigh, d);
        this.actualLow = Math.min(this.actualLow, d);
    }

    public final double deNormalize(double value) {
        double result = ((this.actualLow - this.actualHigh) * value - this.normalizedHigh * this.actualLow + this.actualHigh * this.normalizedLow) / (this.normalizedLow - this.normalizedHigh);
        return result;
    }

    public final ClassItem determineClass(double[] data) {
        int resultIndex = 0;
        switch (this.action) {
            case Equilateral: {
                resultIndex = this.eq.decode(data);
                break;
            }
            case OneOf: {
                resultIndex = EngineArray.indexOfLargest(data);
                break;
            }
            case SingleField: {
                resultIndex = (int)data[0];
                break;
            }
            default: {
                throw new AnalystError("Unknown action: " + (Object)((Object)this.action));
            }
        }
        return this.classes.get(resultIndex);
    }

    public final ClassItem determineClass(int pos, double[] data) {
        int resultIndex = 0;
        double[] d = new double[this.getColumnsNeeded()];
        EngineArray.arrayCopy(data, pos, d, 0, d.length);
        switch (this.action) {
            case Equilateral: {
                resultIndex = this.eq.decode(d);
                break;
            }
            case OneOf: {
                resultIndex = EngineArray.indexOfLargest(d);
                break;
            }
            case SingleField: {
                resultIndex = (int)d[0];
                break;
            }
            default: {
                throw new AnalystError("Invalid action: " + (Object)((Object)this.action));
            }
        }
        if (resultIndex < 0) {
            return null;
        }
        return this.classes.get(resultIndex);
    }

    public final double[] encode(int classNumber) {
        switch (this.action) {
            case OneOf: {
                return this.encodeOneOf(classNumber);
            }
            case Equilateral: {
                return this.encodeEquilateral(classNumber);
            }
            case SingleField: {
                return this.encodeSingleField(classNumber);
            }
        }
        return null;
    }

    public final double[] encode(String str) {
        int classNumber = this.lookup(str);
        if (classNumber == -1) {
            try {
                classNumber = Integer.parseInt(str);
            }
            catch (NumberFormatException ex) {
                throw new QuantError("Can't determine class for: " + str);
            }
        }
        return this.encode(classNumber);
    }

    public final double[] encodeEquilateral(int classNumber) {
        return this.eq.encode(classNumber);
    }

    private double[] encodeOneOf(int classNumber) {
        double[] result = new double[this.getColumnsNeeded()];
        for (int i = 0; i < this.classes.size(); ++i) {
            result[i] = i == classNumber ? this.normalizedHigh : this.normalizedLow;
        }
        return result;
    }

    private double[] encodeSingleField(int classNumber) {
        double[] d = new double[]{classNumber};
        return d;
    }

    public final void fixSingleValue() {
        if (this.action == NormalizationAction.Normalize && Math.abs(this.actualHigh - this.actualLow) < 1.0E-13) {
            this.actualHigh += 1.0;
            this.actualLow -= 1.0;
        }
    }

    public final NormalizationAction getAction() {
        return this.action;
    }

    public final double getActualHigh() {
        return this.actualHigh;
    }

    public final double getActualLow() {
        return this.actualLow;
    }

    public final List<ClassItem> getClasses() {
        return this.classes;
    }

    public final int getColumnsNeeded() {
        switch (this.action) {
            case Ignore: {
                return 0;
            }
            case Equilateral: {
                return this.classes.size() - 1;
            }
            case OneOf: {
                return this.classes.size();
            }
        }
        return 1;
    }

    public final Equilateral getEq() {
        return this.eq;
    }

    public final String getName() {
        return this.name;
    }

    public final double getNormalizedHigh() {
        return this.normalizedHigh;
    }

    public final double getNormalizedLow() {
        return this.normalizedLow;
    }

    public final int getTimeSlice() {
        return this.timeSlice;
    }

    public final void init() {
        if (this.action == NormalizationAction.Equilateral) {
            if (this.classes.size() < 3) {
                throw new QuantError("There must be at least three classes to make use of equilateral normalization.");
            }
            this.eq = new Equilateral(this.classes.size(), this.normalizedHigh, this.normalizedLow);
        }
        for (int i = 0; i < this.classes.size(); ++i) {
            this.lookup.put(this.classes.get(i).getName(), this.classes.get(i).getIndex());
        }
    }

    public final boolean isClassify() {
        return this.action == NormalizationAction.Equilateral || this.action == NormalizationAction.OneOf || this.action == NormalizationAction.SingleField;
    }

    public final boolean isIgnored() {
        return this.action == NormalizationAction.Ignore;
    }

    public final boolean isInput() {
        return !this.output;
    }

    public final boolean isOutput() {
        return this.output;
    }

    public final int lookup(String str) {
        if (!this.lookup.containsKey(str)) {
            return -1;
        }
        return this.lookup.get(str);
    }

    public final void makeClass(NormalizationAction theAction, int classFrom, int classTo, int high, int low) {
        if (this.action != NormalizationAction.Equilateral && this.action != NormalizationAction.OneOf && this.action != NormalizationAction.SingleField) {
            throw new QuantError("Unsupported normalization type");
        }
        this.action = theAction;
        this.classes.clear();
        this.normalizedHigh = high;
        this.normalizedLow = low;
        this.actualHigh = 0.0;
        this.actualLow = 0.0;
        int index = 0;
        for (int i = classFrom; i < classTo; ++i) {
            this.classes.add(new ClassItem("" + i, index++));
        }
    }

    public final void makeClass(NormalizationAction theAction, String[] cls, double high, double low) {
        if (this.action != NormalizationAction.Equilateral && this.action != NormalizationAction.OneOf && this.action != NormalizationAction.SingleField) {
            throw new QuantError("Unsupported normalization type");
        }
        this.action = theAction;
        this.classes.clear();
        this.normalizedHigh = high;
        this.normalizedLow = low;
        this.actualHigh = 0.0;
        this.actualLow = 0.0;
        for (int i = 0; i < cls.length; ++i) {
            this.classes.add(new ClassItem(cls[i], i));
        }
    }

    public final void makePassThrough() {
        this.normalizedHigh = 0.0;
        this.normalizedLow = 0.0;
        this.actualHigh = 0.0;
        this.actualLow = 0.0;
        this.action = NormalizationAction.PassThrough;
    }

    public final double normalize(double value) {
        return (value - this.actualLow) / (this.actualHigh - this.actualLow) * (this.normalizedHigh - this.normalizedLow) + this.normalizedLow;
    }

    public final void setAction(NormalizationAction theAction) {
        this.action = theAction;
    }

    public final void setActualHigh(double theActualHigh) {
        this.actualHigh = theActualHigh;
    }

    public final void setActualLow(double theActualLow) {
        this.actualLow = theActualLow;
    }

    public final void setName(String theName) {
        this.name = theName;
    }

    public final void setNormalizedHigh(double theNormalizedHigh) {
        this.normalizedHigh = theNormalizedHigh;
    }

    public final void setNormalizedLow(double theNormalizedLow) {
        this.normalizedLow = theNormalizedLow;
    }

    public final void setOutput(boolean b) {
        this.output = b;
    }

    public final void setTimeSlice(int theTimeSlice) {
        this.timeSlice = theTimeSlice;
    }

    public final String toString() {
        StringBuilder result = new StringBuilder("[");
        result.append(this.getClass().getSimpleName());
        result.append(" name=");
        result.append(this.name);
        result.append(", actualHigh=");
        result.append(this.actualHigh);
        result.append(", actualLow=");
        result.append(this.actualLow);
        result.append("]");
        return result.toString();
    }

    public int determineMode(EncogAnalyst analyst) {
        if (!this.isClassify()) {
            throw new AnalystError("Can only calculate the mode for a class.");
        }
        DataField df = analyst.getScript().findDataField(this.name);
        AnalystClassItem m = null;
        int result = 0;
        int idx = 0;
        for (AnalystClassItem item : df.getClassMembers()) {
            if (m == null || m.getCount() < item.getCount()) {
                m = item;
                result = idx;
            }
            ++idx;
        }
        return result;
    }
}

