/*
 * Decompiled with CFR 0.152.
 */
package org.encog.app.analyst.util;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.encog.app.analyst.AnalystError;
import org.encog.util.csv.CSVFormat;
import org.encog.util.csv.ReadCSV;

public class CSVHeaders {
    private final List<String> headerList = new ArrayList<String>();
    private final Map<String, Integer> columnMapping = new HashMap<String, Integer>();

    public static int parseTimeSlice(String name) {
        String[] values;
        int index1 = name.indexOf(40);
        if (index1 == -1) {
            return 0;
        }
        int index2 = name.indexOf(41);
        if (index2 == -1) {
            return 0;
        }
        if (index2 < index1) {
            return 0;
        }
        String list = name.substring(index1 + 1, index2);
        for (String value : values = list.split(",")) {
            String str = value.trim();
            if (!str.toLowerCase().startsWith("t")) continue;
            int slice = Integer.parseInt(str.substring(1));
            return slice;
        }
        return 0;
    }

    public static String tagColumn(String name, int part, int timeSlice, boolean multiPart) {
        StringBuilder result = new StringBuilder();
        result.append(name);
        if (multiPart || timeSlice != 0) {
            result.append('(');
            if (multiPart) {
                result.append('p');
                result.append(part);
            }
            if (timeSlice != 0) {
                if (multiPart) {
                    result.append(',');
                }
                result.append('t');
                if (timeSlice > 0) {
                    result.append('+');
                }
                result.append(timeSlice);
            }
            result.append(')');
        }
        return result.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CSVHeaders(File filename, boolean headers, CSVFormat format) {
        ReadCSV csv = null;
        try {
            csv = new ReadCSV(filename.toString(), headers, format);
            if (csv.next()) {
                if (headers) {
                    for (String str : csv.getColumnNames()) {
                        this.headerList.add(str);
                    }
                } else {
                    for (int i = 0; i < csv.getColumnCount(); ++i) {
                        this.headerList.add("field:" + (i + 1));
                    }
                }
            }
            this.init();
        }
        finally {
            if (csv != null) {
                csv.close();
            }
        }
    }

    public CSVHeaders(List<String> inputHeadings) {
        for (String header : inputHeadings) {
            this.headerList.add(header);
        }
        this.init();
    }

    public CSVHeaders(String[] inputHeadings) {
        for (String header : inputHeadings) {
            this.headerList.add(header);
        }
        this.init();
    }

    public final int find(String name) {
        String key = name.toLowerCase();
        if (!this.columnMapping.containsKey(key)) {
            throw new AnalystError("Can't find column: " + name.toLowerCase());
        }
        return this.columnMapping.get(key);
    }

    public final String getBaseHeader(int index) {
        String result = this.headerList.get(index);
        int loc = result.indexOf(40);
        if (loc != -1) {
            result = result.substring(0, loc);
        }
        return result.trim();
    }

    public final String getHeader(int index) {
        return this.headerList.get(index);
    }

    public final List<String> getHeaders() {
        return this.headerList;
    }

    public final int getSlice(int currentIndex) {
        String[] values;
        String name = this.headerList.get(currentIndex);
        int index1 = name.indexOf(40);
        if (index1 == -1) {
            return 0;
        }
        int index2 = name.indexOf(41);
        if (index2 == -1) {
            return 0;
        }
        if (index2 < index1) {
            return 0;
        }
        String list = name.substring(index1 + 1, index2);
        for (String value : values = list.split(",")) {
            String str = value.trim();
            if (!str.toLowerCase().startsWith("t")) continue;
            str = value.trim().substring(1).trim();
            if (str.charAt(0) == '+') {
                str = str.substring(1);
            }
            int slice = Integer.parseInt(str);
            return slice;
        }
        return 0;
    }

    private void init() {
        int index = 0;
        for (String str : this.headerList) {
            this.columnMapping.put(str.toLowerCase(), index++);
        }
        this.validateSameName();
    }

    public final int size() {
        return this.headerList.size();
    }

    private void validateSameName() {
        for (int i = 0; i < this.headerList.size(); ++i) {
            for (int j = 0; j < this.headerList.size(); ++j) {
                if (i == j || !this.headerList.get(i).equalsIgnoreCase(this.headerList.get(j))) continue;
                throw new AnalystError("Multiple fields named: " + this.headerList.get(i));
            }
        }
    }
}

