/*
 * Decompiled with CFR 0.152.
 */
package org.encog.bot;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.encog.bot.BotError;
import org.encog.parse.tags.read.ReadHTML;
import org.encog.util.logging.EncogLogging;

public final class BotUtil {
    public static final int BUFFER_SIZE = 32768;

    public static void downloadPage(URL url, File file) {
        try {
            int length;
            byte[] buffer = new byte[32768];
            FileOutputStream fos = new FileOutputStream(file);
            InputStream is = url.openStream();
            do {
                if ((length = is.read(buffer)) < 0) continue;
                fos.write(buffer, 0, length);
            } while (length >= 0);
            fos.close();
        }
        catch (IOException e) {
            EncogLogging.log(e);
            throw new BotError(e);
        }
    }

    public static String extract(String str, String token1, String token2, int index) {
        String searchStr = str.toLowerCase();
        String token1Lower = token1.toLowerCase();
        String token2Lower = token2.toLowerCase();
        int count = index;
        int location1 = -1;
        int location2 = -1;
        do {
            if ((location1 = searchStr.indexOf(token1Lower, location1 + 1)) != -1) continue;
            return null;
        } while (--count > 0);
        location2 = searchStr.indexOf(token2Lower, location1 + 1);
        if (location2 == -1) {
            return null;
        }
        return str.substring(location1 + token1Lower.length(), location2);
    }

    public static String extractFromIndex(String str, String token1, String token2, int index, int occurence) {
        int location1;
        String searchStr = str.toLowerCase();
        String token1Lower = token1.toLowerCase();
        String token2Lower = token2.toLowerCase();
        int count = occurence;
        int location2 = location1 = index - 1;
        do {
            if ((location1 = searchStr.indexOf(token1Lower, location1 + 1)) != -1) continue;
            return null;
        } while (--count > 0);
        location2 = searchStr.indexOf(token2Lower, location1 + 1);
        if (location2 == -1) {
            return null;
        }
        return str.substring(location1 + token1Lower.length(), location2);
    }

    public static int findOccurance(String search, String searchFor, int index) {
        int count = index;
        String lowerSearch = search.toLowerCase();
        int result = -1;
        do {
            result = lowerSearch.indexOf(searchFor, result + 1);
        } while (count-- > 0);
        return result;
    }

    public static String loadPage(InputStream is) {
        try {
            int length;
            StringBuilder result = new StringBuilder();
            byte[] buffer = new byte[32768];
            do {
                if ((length = is.read(buffer)) < 0) continue;
                result.append(new String(buffer, 0, length));
            } while (length >= 0);
            return result.toString();
        }
        catch (IOException e) {
            EncogLogging.log(e);
            throw new BotError(e);
        }
    }

    public static String loadPage(URL url) {
        try {
            int length;
            StringBuilder result = new StringBuilder();
            byte[] buffer = new byte[32768];
            InputStream is = url.openStream();
            do {
                if ((length = is.read(buffer)) < 0) continue;
                result.append(new String(buffer, 0, length));
            } while (length >= 0);
            return result.toString();
        }
        catch (IOException e) {
            EncogLogging.log(e);
            throw new BotError(e);
        }
    }

    public static String stripTags(String str) {
        int ch;
        ByteArrayInputStream is = new ByteArrayInputStream(str.getBytes());
        StringBuilder result = new StringBuilder();
        ReadHTML html = new ReadHTML(is);
        while ((ch = html.read()) != -1) {
            if (ch == 0) continue;
            result.append((char)ch);
        }
        return result.toString();
    }

    private BotUtil() {
    }
}

