/*
 * Decompiled with CFR 0.152.
 */
package org.encog.mathutil;

public class LinearCongruentialGenerator {
    public static final long DEFAULT_MOD1 = 2L;
    public static final long DEFAULT_MOD2 = 32L;
    public static final long DEFAULT_MULT = 1103515245L;
    public static final long DEFAULT_INC = 12345L;
    private final long modulus;
    private final long multiplier;
    private final long increment;
    private long seed;
    public static final long MAX_RAND = 0xFFFFFFFFL;

    public LinearCongruentialGenerator(long theSeed) {
        this((long)Math.pow(2.0, 32.0), 1103515245L, 12345L, theSeed);
    }

    public LinearCongruentialGenerator(long theModulus, long theMultiplier, long theIncrement, long theSeed) {
        this.modulus = theModulus;
        this.multiplier = theMultiplier;
        this.increment = theIncrement;
        this.seed = theSeed;
    }

    public final long getIncrement() {
        return this.increment;
    }

    public final long getModulus() {
        return this.modulus;
    }

    public final long getMultiplier() {
        return this.multiplier;
    }

    public final long getSeed() {
        return this.seed;
    }

    public final double nextDouble() {
        double result = (double)this.nextLong() / 4.294967295E9;
        return result;
    }

    public final long nextLong() {
        this.seed = (this.multiplier * this.seed + this.increment) % this.modulus;
        return this.seed;
    }

    public final double range(double min, double max) {
        double range = max - min;
        return range * this.nextDouble() + min;
    }

    public final void setSeed(long theSeed) {
        this.seed = theSeed;
    }
}

