/*
 * Decompiled with CFR 0.152.
 */
package org.encog.ml.genetic.genome;

import java.util.Comparator;
import org.encog.ml.genetic.genome.CalculateGenomeScore;
import org.encog.ml.genetic.genome.Genome;

public class GenomeComparator
implements Comparator<Genome> {
    private final CalculateGenomeScore calculateScore;

    public GenomeComparator(CalculateGenomeScore theCalculateScore) {
        this.calculateScore = theCalculateScore;
    }

    public final double applyBonus(double value, double bonus) {
        double amount = value * bonus;
        if (this.calculateScore.shouldMinimize()) {
            return value - amount;
        }
        return value + amount;
    }

    public final double applyPenalty(double value, double bonus) {
        double amount = value * bonus;
        if (this.calculateScore.shouldMinimize()) {
            return value - amount;
        }
        return value + amount;
    }

    public final double bestScore(double d1, double d2) {
        if (this.calculateScore.shouldMinimize()) {
            return Math.min(d1, d2);
        }
        return Math.max(d1, d2);
    }

    @Override
    public final int compare(Genome genome1, Genome genome2) {
        return Double.compare(genome1.getScore(), genome2.getScore());
    }

    public final CalculateGenomeScore getCalculateScore() {
        return this.calculateScore;
    }

    public final boolean isBetterThan(double d1, double d2) {
        if (this.calculateScore.shouldMinimize()) {
            return d1 < d2;
        }
        return d1 > d2;
    }
}

