/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.neat;

import java.io.Serializable;
import org.encog.engine.network.activation.ActivationFunction;
import org.encog.engine.network.activation.ActivationLinear;
import org.encog.engine.network.activation.ActivationSigmoid;
import org.encog.ml.genetic.population.BasicPopulation;
import org.encog.neural.NeuralNetworkError;
import org.encog.neural.neat.training.NEATGenome;
import org.encog.neural.neat.training.NEATInnovationList;

public class NEATPopulation
extends BasicPopulation
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String PROPERTY_NEAT_ACTIVATION = "neatAct";
    public static final String PROPERTY_OUTPUT_ACTIVATION = "outAct";
    int inputCount;
    int outputCount;
    private ActivationFunction neatActivationFunction = new ActivationSigmoid();
    private boolean snapshot;
    private ActivationFunction outputActivationFunction = new ActivationLinear();

    public NEATPopulation(int inputCount, int outputCount, int populationSize) {
        super(populationSize);
        this.inputCount = inputCount;
        this.outputCount = outputCount;
        if (populationSize == 0) {
            throw new NeuralNetworkError("Population must have more than zero genomes.");
        }
        for (int i = 0; i < populationSize; ++i) {
            NEATGenome genome = new NEATGenome(this.assignGenomeID(), inputCount, outputCount);
            this.add(genome);
        }
        NEATGenome genome = (NEATGenome)this.getGenomes().get(0);
        this.setInnovations(new NEATInnovationList(this, genome.getLinks(), genome.getNeurons()));
    }

    public NEATPopulation() {
    }

    public int getInputCount() {
        return this.inputCount;
    }

    public void setInputCount(int inputCount) {
        this.inputCount = inputCount;
    }

    public int getOutputCount() {
        return this.outputCount;
    }

    public void setOutputCount(int outputCount) {
        this.outputCount = outputCount;
    }

    public ActivationFunction getNeatActivationFunction() {
        return this.neatActivationFunction;
    }

    public void setNeatActivationFunction(ActivationFunction neatActivationFunction) {
        this.neatActivationFunction = neatActivationFunction;
    }

    public ActivationFunction getOutputActivationFunction() {
        return this.outputActivationFunction;
    }

    public void setOutputActivationFunction(ActivationFunction outputActivationFunction) {
        this.outputActivationFunction = outputActivationFunction;
    }

    public boolean isSnapshot() {
        return this.snapshot;
    }

    public void setSnapshot(boolean snapshot) {
        this.snapshot = snapshot;
    }
}

