/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.neat;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.encog.neural.neat.NEATLink;
import org.encog.neural.neat.NEATNetwork;
import org.encog.neural.neat.NEATNeuron;
import org.encog.neural.neat.NEATNeuronType;
import org.encog.neural.neat.PersistNEATPopulation;
import org.encog.persist.EncogFileSection;
import org.encog.persist.EncogPersistor;
import org.encog.persist.EncogReadHelper;
import org.encog.persist.EncogWriteHelper;
import org.encog.util.csv.CSVFormat;

public class PersistNEATNetwork
implements EncogPersistor {
    @Override
    public int getFileVersion() {
        return 1;
    }

    @Override
    public String getPersistClassString() {
        return "NEATNetwork";
    }

    @Override
    public Object read(InputStream is) {
        EncogFileSection section;
        NEATNetwork result = new NEATNetwork();
        EncogReadHelper in = new EncogReadHelper(is);
        HashMap<Integer, NEATNeuron> neuronMap = new HashMap<Integer, NEATNeuron>();
        while ((section = in.readNextSection()) != null) {
            List<String> cols;
            Map<String, String> params;
            if (section.getSectionName().equals("NEAT") && section.getSubSectionName().equals("PARAMS")) {
                params = section.parseParams();
                result.getProperties().putAll(params);
            }
            if (section.getSectionName().equals("NEAT") && section.getSubSectionName().equals("NETWORK")) {
                params = section.parseParams();
                result.setInputCount(EncogFileSection.parseInt(params, "inputCount"));
                result.setOutputCount(EncogFileSection.parseInt(params, "outputCount"));
                result.setActivationFunction(EncogFileSection.parseActivationFunction(params, "activationFunction"));
                result.setOutputActivationFunction(EncogFileSection.parseActivationFunction(params, "outAct"));
                result.setNetworkDepth(EncogFileSection.parseInt(params, "depth"));
                result.setSnapshot(EncogFileSection.parseBoolean(params, "snapshot"));
                continue;
            }
            if (section.getSectionName().equals("NEAT") && section.getSubSectionName().equals("NEURONS")) {
                for (String line : section.getLines()) {
                    cols = EncogFileSection.splitColumns(line);
                    long neuronID = Integer.parseInt(cols.get(0));
                    NEATNeuronType neuronType = PersistNEATPopulation.stringToNeuronType(cols.get(1));
                    double activationResponse = CSVFormat.EG_FORMAT.parse(cols.get(2));
                    double splitY = CSVFormat.EG_FORMAT.parse(cols.get(3));
                    double splitX = CSVFormat.EG_FORMAT.parse(cols.get(4));
                    NEATNeuron neatNeuron = new NEATNeuron(neuronType, neuronID, splitY, splitX, activationResponse);
                    result.getNeurons().add(neatNeuron);
                    neuronMap.put((int)neuronID, neatNeuron);
                }
                continue;
            }
            if (!section.getSectionName().equals("NEAT") || !section.getSubSectionName().equals("LINKS")) continue;
            for (String line : section.getLines()) {
                cols = EncogFileSection.splitColumns(line);
                int fromID = Integer.parseInt(cols.get(0));
                int toID = Integer.parseInt(cols.get(1));
                boolean recurrent = Integer.parseInt(cols.get(2)) > 0;
                double weight = CSVFormat.EG_FORMAT.parse(cols.get(3));
                NEATNeuron fromNeuron = (NEATNeuron)neuronMap.get(fromID);
                NEATNeuron toNeuron = (NEATNeuron)neuronMap.get(toID);
                NEATLink neatLink = new NEATLink(weight, fromNeuron, toNeuron, recurrent);
                fromNeuron.getOutputboundLinks().add(neatLink);
                toNeuron.getInboundLinks().add(neatLink);
            }
        }
        return result;
    }

    @Override
    public void save(OutputStream os, Object obj) {
        EncogWriteHelper out = new EncogWriteHelper(os);
        NEATNetwork neat = (NEATNetwork)obj;
        out.addSection("NEAT");
        out.addSubSection("PARAMS");
        out.addProperties(neat.getProperties());
        out.addSubSection("NETWORK");
        out.writeProperty("inputCount", neat.getInputCount());
        out.writeProperty("outputCount", neat.getOutputCount());
        out.writeProperty("activationFunction", neat.getActivationFunction());
        out.writeProperty("outAct", neat.getOutputActivationFunction());
        out.writeProperty("depth", neat.getNetworkDepth());
        out.writeProperty("snapshot", neat.isSnapshot());
        out.addSubSection("NEURONS");
        for (NEATNeuron neatNeuron : neat.getNeurons()) {
            out.addColumn(neatNeuron.getNeuronID());
            out.addColumn(PersistNEATPopulation.neuronTypeToString(neatNeuron.getNeuronType()));
            out.addColumn(neatNeuron.getActivationResponse());
            out.addColumn(neatNeuron.getSplitX());
            out.addColumn(neatNeuron.getSplitY());
            out.writeLine();
        }
        out.addSubSection("LINKS");
        for (NEATNeuron neatNeuron : neat.getNeurons()) {
            for (NEATLink link : neatNeuron.getOutputboundLinks()) {
                this.writeLink(out, link);
            }
        }
        out.flush();
    }

    private void writeLink(EncogWriteHelper out, NEATLink link) {
        out.addColumn(link.getFromNeuron().getNeuronID());
        out.addColumn(link.getToNeuron().getNeuronID());
        out.addColumn(link.isRecurrent());
        out.addColumn(link.getWeight());
        out.writeLine();
    }
}

