/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.networks.training.concurrent.performers;

import java.util.concurrent.atomic.AtomicBoolean;
import org.encog.ml.train.MLTrain;
import org.encog.neural.NeuralNetworkError;
import org.encog.neural.networks.training.concurrent.ConcurrentTrainingManager;
import org.encog.neural.networks.training.concurrent.jobs.TrainingJob;
import org.encog.neural.networks.training.concurrent.performers.ConcurrentTrainingPerformer;
import org.encog.neural.networks.training.concurrent.performers.PerformerTask;
import org.encog.util.Stopwatch;
import org.encog.util.concurrency.EngineConcurrency;

public class ConcurrentTrainingPerformerCPU
implements ConcurrentTrainingPerformer,
Runnable {
    private final AtomicBoolean ready = new AtomicBoolean(true);
    private TrainingJob currentJob;
    private ConcurrentTrainingManager manager;
    private final int number;

    public ConcurrentTrainingPerformerCPU(int number) {
        this.number = number;
    }

    @Override
    public final ConcurrentTrainingManager getManager() {
        return this.manager;
    }

    public final int getNumber() {
        return this.number;
    }

    @Override
    public final void perform(TrainingJob job) {
        if (!this.ready.get()) {
            throw new NeuralNetworkError("Performer is already performing a job.");
        }
        this.ready.set(false);
        this.currentJob = job;
        PerformerTask task = new PerformerTask(this);
        EngineConcurrency.getInstance().processTask(task);
    }

    @Override
    public final boolean ready() {
        return this.ready.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void run() {
        Stopwatch watch = new Stopwatch();
        try {
            watch.start();
            this.currentJob.createTrainer(this.manager.isSingleThreaded());
            MLTrain train = this.currentJob.getTrain();
            int interation = 1;
            while (this.currentJob.shouldContinue()) {
                train.iteration();
                ++interation;
            }
            watch.stop();
        }
        catch (Throwable t) {
            this.currentJob.setError(t);
        }
        finally {
            this.ready.set(true);
            this.manager.jobDone(watch.getElapsedMilliseconds(), this);
        }
    }

    @Override
    public final void setManager(ConcurrentTrainingManager manager) {
        this.manager = manager;
    }

    public final String toString() {
        return "[CPU-Performer: " + this.number + "]";
    }
}

