/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.pattern;

import org.encog.engine.network.activation.ActivationFunction;
import org.encog.ml.MLMethod;
import org.encog.ml.svm.KernelType;
import org.encog.ml.svm.SVM;
import org.encog.ml.svm.SVMType;
import org.encog.neural.pattern.NeuralNetworkPattern;
import org.encog.neural.pattern.PatternError;

public class SVMPattern
implements NeuralNetworkPattern {
    private int inputNeurons;
    private int outputNeurons;
    private boolean regression = true;
    private KernelType kernelType = KernelType.RadialBasisFunction;
    private SVMType svmType = SVMType.EpsilonSupportVectorRegression;

    @Override
    public final void addHiddenLayer(int count) {
        throw new PatternError("A SVM network has no hidden layers.");
    }

    @Override
    public final void clear() {
        this.inputNeurons = 0;
        this.outputNeurons = 0;
    }

    @Override
    public final MLMethod generate() {
        if (this.outputNeurons != 1) {
            throw new PatternError("A SVM may only have one output.");
        }
        SVM network = new SVM(this.inputNeurons, this.svmType, this.kernelType);
        return network;
    }

    public final int getInputNeurons() {
        return this.inputNeurons;
    }

    public final int getOutputNeurons() {
        return this.outputNeurons;
    }

    public final boolean isRegression() {
        return this.regression;
    }

    @Override
    public final void setActivationFunction(ActivationFunction activation) {
        throw new PatternError("A SVM network can't specify a custom activation function.");
    }

    @Override
    public final void setInputNeurons(int count) {
        this.inputNeurons = count;
    }

    public final void setKernelType(KernelType kernelType) {
        this.kernelType = kernelType;
    }

    @Override
    public final void setOutputNeurons(int count) {
        this.outputNeurons = count;
    }

    public final void setRegression(boolean regression) {
        this.regression = regression;
    }

    public final void setSVMType(SVMType svmType) {
        this.svmType = svmType;
    }
}

