/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.thermal;

import org.encog.ml.BasicML;
import org.encog.ml.MLAutoAssocation;
import org.encog.ml.MLMethod;
import org.encog.ml.MLResettable;
import org.encog.ml.data.specific.BiPolarNeuralData;
import org.encog.neural.NeuralNetworkError;
import org.encog.util.EngineArray;

public abstract class ThermalNetwork
extends BasicML
implements MLMethod,
MLAutoAssocation,
MLResettable {
    private static final long serialVersionUID = 1L;
    private BiPolarNeuralData currentState;
    private double[] weights;
    private int neuronCount;

    public ThermalNetwork() {
    }

    public ThermalNetwork(int neuronCount) {
        this.neuronCount = neuronCount;
        this.weights = new double[neuronCount * neuronCount];
        this.currentState = new BiPolarNeuralData(neuronCount);
    }

    public final void addWeight(int fromNeuron, int toNeuron, double value) {
        int index = toNeuron * this.neuronCount + fromNeuron;
        if (index >= this.weights.length) {
            throw new NeuralNetworkError("Out of range: fromNeuron:" + fromNeuron + ", toNeuron: " + toNeuron);
        }
        int n = index;
        this.weights[n] = this.weights[n] + value;
    }

    public final double calculateEnergy() {
        double tempE = 0.0;
        int neuronCount = this.getNeuronCount();
        for (int i = 0; i < neuronCount; ++i) {
            for (int j = 0; j < neuronCount; ++j) {
                if (i == j) continue;
                tempE += this.getWeight(i, j) * this.currentState.getData(i) * this.currentState.getData(j);
            }
        }
        return -1.0 * tempE / 2.0;
    }

    public final void clear() {
        EngineArray.fill(this.weights, 0.0);
    }

    public final BiPolarNeuralData getCurrentState() {
        return this.currentState;
    }

    public final int getNeuronCount() {
        return this.neuronCount;
    }

    public final double getWeight(int fromNeuron, int toNeuron) {
        int index = toNeuron * this.neuronCount + fromNeuron;
        return this.weights[index];
    }

    public final double[] getWeights() {
        return this.weights;
    }

    public final void init(int neuronCount, double[] weights, double[] output) {
        if (neuronCount != output.length) {
            throw new NeuralNetworkError("Neuron count(" + neuronCount + ") must match output count(" + output.length + ").");
        }
        if (neuronCount * neuronCount != weights.length) {
            throw new NeuralNetworkError("Weight count(" + weights.length + ") must be the square of the neuron count(" + neuronCount + ").");
        }
        this.neuronCount = neuronCount;
        this.weights = weights;
        this.currentState = new BiPolarNeuralData(neuronCount);
        this.currentState.setData(output);
    }

    @Override
    public final void reset() {
        this.reset(0);
    }

    @Override
    public final void reset(int seed) {
        this.getCurrentState().clear();
        EngineArray.fill(this.weights, 0.0);
    }

    public final void setCurrentState(BiPolarNeuralData state) {
        for (int i = 0; i < state.size(); ++i) {
            this.currentState.setData(i, state.getData(i));
        }
    }

    public final void setCurrentState(double[] s) {
        this.currentState = new BiPolarNeuralData(s.length);
        EngineArray.arrayCopy(s, this.currentState.getData());
    }

    public final void setNeuronCount(int c) {
        this.neuronCount = c;
    }

    public final void setWeight(int fromNeuron, int toNeuron, double value) {
        int index = toNeuron * this.neuronCount + fromNeuron;
        this.weights[index] = value;
    }

    public final void setWeights(double[] w) {
        this.weights = w;
    }
}

