/*
 * Decompiled with CFR 0.152.
 */
package org.encog.util;

public class HTMLReport {
    private StringBuilder text = new StringBuilder();

    public void beginHTML() {
        this.text.append("<html>");
    }

    public void endHTML() {
        this.text.append("</html>");
    }

    public void title(String str) {
        this.text.append("<head><title>");
        this.text.append(str);
        this.text.append("</title></head>");
    }

    public void beginPara() {
        this.text.append("<p>");
    }

    public void endPara() {
        this.text.append("</p>");
    }

    public void bold(String str) {
        this.text.append("<b>");
        this.text.append(HTMLReport.encode(str));
        this.text.append("</b>");
    }

    public void para(String str) {
        this.text.append("<p>");
        this.text.append(HTMLReport.encode(str));
        this.text.append("</p>");
    }

    public void clear() {
        this.text.setLength(0);
    }

    public String toString() {
        return this.text.toString();
    }

    public void beginBody() {
        this.text.append("<body>");
    }

    public void endBody() {
        this.text.append("</body>");
    }

    public void h1(String title) {
        this.text.append("<h1>");
        this.text.append(HTMLReport.encode(title));
        this.text.append("</h1>");
    }

    public void beginTable() {
        this.text.append("<table border=\"1\">");
    }

    public void endTable() {
        this.text.append("</table>");
    }

    public void beginRow() {
        this.text.append("<tr>");
    }

    public void endRow() {
        this.text.append("</tr>");
    }

    public void header(String head) {
        this.text.append("<th>");
        this.text.append(HTMLReport.encode(head));
        this.text.append("</th>");
    }

    public void cell(String head) {
        this.cell(head, 0);
    }

    public void cell(String head, int colSpan) {
        this.text.append("<td");
        if (colSpan > 0) {
            this.text.append(" colspan=\"");
            this.text.append(colSpan);
            this.text.append("\"");
        }
        this.text.append(">");
        this.text.append(HTMLReport.encode(head));
        this.text.append("</td>");
    }

    public void tablePair(String name, String value) {
        this.beginRow();
        this.text.append("<td><b>" + HTMLReport.encode(name) + "</b></td>");
        this.cell(value);
        this.endRow();
    }

    public static String encode(String str) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            if (ch == '<') {
                result.append("&lt;");
                continue;
            }
            if (ch == '>') {
                result.append("&gt;");
                continue;
            }
            if (ch == '&') {
                result.append("&amp;");
                continue;
            }
            result.append(ch);
        }
        return result.toString();
    }

    public void h2(String title) {
        this.text.append("<h2>");
        this.text.append(HTMLReport.encode(title));
        this.text.append("</h2>");
    }

    public void h3(String title) {
        this.text.append("<h3>");
        this.text.append(HTMLReport.encode(title));
        this.text.append("</h3>");
    }

    public void beginList() {
        this.text.append("<ul>");
    }

    public void listItem(String str) {
        this.text.append("<li>");
        this.text.append(HTMLReport.encode(str));
    }

    public void endList() {
        this.text.append("</ul>");
    }

    public void beginTableInCell(int colSpan) {
        this.text.append("<td");
        if (colSpan > 0) {
            this.text.append(" colspan=\"");
            this.text.append(colSpan);
            this.text.append("\"");
        }
        this.text.append(">");
        this.text.append("<table border=\"1\" width=\"100%\">");
    }

    public void endTableInCell() {
        this.text.append("</table></td>");
    }
}

