/*
 * Decompiled with CFR 0.152.
 */
package org.encog.util.arrayutil;

import org.encog.ml.data.MLDataSet;
import org.encog.ml.data.basic.BasicMLData;
import org.encog.ml.data.basic.BasicMLDataPair;
import org.encog.ml.data.basic.BasicMLDataSet;
import org.encog.util.arrayutil.TemporalType;
import org.encog.util.arrayutil.TemporalWindowField;

public class TemporalWindowArray {
    private int inputWindow;
    private int predictWindow;
    private TemporalWindowField[] fields;

    public TemporalWindowArray(int theInputWindow, int thePredictWindow) {
        this.inputWindow = theInputWindow;
        this.predictWindow = thePredictWindow;
    }

    public final void analyze(double[] array) {
        this.fields = new TemporalWindowField[1];
        this.fields[0] = new TemporalWindowField("0");
        this.fields[0].setAction(TemporalType.InputAndPredict);
    }

    public final void analyze(double[][] array) {
        int length = array[0].length;
        this.fields = new TemporalWindowField[length];
        for (int i = 0; i < length; ++i) {
            this.fields[i] = new TemporalWindowField("" + i);
            this.fields[i].setAction(TemporalType.InputAndPredict);
        }
    }

    public final int countInputFields() {
        int result = 0;
        for (TemporalWindowField field : this.fields) {
            if (!field.getInput()) continue;
            ++result;
        }
        return result;
    }

    public final int countPredictFields() {
        int result = 0;
        for (TemporalWindowField field : this.fields) {
            if (!field.getPredict()) continue;
            ++result;
        }
        return result;
    }

    public final TemporalWindowField[] getFields() {
        return this.fields;
    }

    public final int getInputWindow() {
        return this.inputWindow;
    }

    public final int getPredictWindow() {
        return this.predictWindow;
    }

    public final MLDataSet process(double[] data) {
        BasicMLDataSet result = new BasicMLDataSet();
        int totalWindowSize = this.inputWindow + this.predictWindow;
        int stopPoint = data.length - totalWindowSize;
        for (int i = 0; i < stopPoint; ++i) {
            int j;
            BasicMLData inputData = new BasicMLData(this.inputWindow);
            BasicMLData idealData = new BasicMLData(this.predictWindow);
            int index = i;
            for (j = 0; j < this.inputWindow; ++j) {
                inputData.setData(j, data[index++]);
            }
            for (j = 0; j < this.predictWindow; ++j) {
                idealData.setData(j, data[index++]);
            }
            BasicMLDataPair pair = new BasicMLDataPair(inputData, idealData);
            result.add(pair);
        }
        return result;
    }

    public final void setInputWindow(int theInputWindow) {
        this.inputWindow = theInputWindow;
    }

    public final void setPredictWindow(int thePredictWindow) {
        this.predictWindow = thePredictWindow;
    }
}

