/*
 * Decompiled with CFR 0.152.
 */
package org.encog;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.encog.plugin.EncogPluginBase;
import org.encog.plugin.EncogPluginLogging1;
import org.encog.plugin.system.SystemActivationPlugin;
import org.encog.plugin.system.SystemLoggingPlugin;
import org.encog.plugin.system.SystemMethodsPlugin;
import org.encog.plugin.system.SystemTrainingPlugin;
import org.encog.util.concurrency.EngineConcurrency;

public final class Encog {
    public static final String VERSION = "3.0.0";
    private static final String FILE_VERSION = "1";
    public static final int DEFAULT_PRECISION = 10;
    public static final double DEFAULT_DOUBLE_EQUAL = 1.0E-13;
    public static final String ENCOG_VERSION = "encog.version";
    public static final String ENCOG_FILE_VERSION = "encog.file.version";
    private static Encog instance = new Encog();
    private EncogPluginLogging1 loggingPlugin;
    private final List<EncogPluginBase> plugins = new ArrayList<EncogPluginBase>();
    private final Map<String, String> properties = new HashMap<String, String>();

    public static Encog getInstance() {
        return instance;
    }

    private Encog() {
        this.properties.put(ENCOG_VERSION, VERSION);
        this.properties.put(ENCOG_FILE_VERSION, FILE_VERSION);
        this.registerPlugin(new SystemLoggingPlugin());
        this.registerPlugin(new SystemMethodsPlugin());
        this.registerPlugin(new SystemTrainingPlugin());
        this.registerPlugin(new SystemActivationPlugin());
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void registerPlugin(EncogPluginBase plugin) {
        if (plugin.getPluginServiceType() != 0 && plugin.getPluginServiceType() == 1) {
            if (this.loggingPlugin != null) {
                this.plugins.remove(this.loggingPlugin);
            }
            this.loggingPlugin = (EncogPluginLogging1)plugin;
        }
        this.plugins.add(plugin);
    }

    public void unregisterPlugin(EncogPluginBase plugin) {
        if (plugin == this.loggingPlugin) {
            this.loggingPlugin = new SystemLoggingPlugin();
        }
        this.plugins.remove(plugin);
    }

    public void shutdown() {
        EngineConcurrency.getInstance().shutdown(10000L);
    }

    public EncogPluginLogging1 getLoggingPlugin() {
        return this.loggingPlugin;
    }

    public Collection<EncogPluginBase> getPlugins() {
        return this.plugins;
    }
}

