/*
 * Decompiled with CFR 0.152.
 */
package org.encog.app.analyst.script;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.encog.app.analyst.AnalystFileFormat;
import org.encog.app.analyst.script.DataField;
import org.encog.app.analyst.script.ScriptLoad;
import org.encog.app.analyst.script.ScriptSave;
import org.encog.app.analyst.script.normalize.AnalystField;
import org.encog.app.analyst.script.normalize.AnalystNormalize;
import org.encog.app.analyst.script.prop.ScriptProperties;
import org.encog.app.analyst.script.segregate.AnalystSegregate;
import org.encog.app.analyst.script.task.AnalystTask;
import org.encog.util.csv.CSVFormat;

public class AnalystScript {
    public static final int DEFAULT_MAX_CLASS = 50;
    private DataField[] fields;
    private final AnalystNormalize normalize = new AnalystNormalize(this);
    private final AnalystSegregate segregate = new AnalystSegregate();
    private final Set<String> generated = new HashSet<String>();
    private final Map<String, AnalystTask> tasks = new HashMap<String, AnalystTask>();
    private final ScriptProperties properties = new ScriptProperties();
    private String basePath;

    public AnalystScript() {
        this.properties.setProperty("SETUP:CONFIG_csvFormat", AnalystFileFormat.DECPNT_COMMA);
        this.properties.setProperty("SETUP:CONFIG_maxClassCount", 50);
        this.properties.setProperty("SETUP:CONFIG_allowedClasses", "integer,string");
    }

    public final void addTask(AnalystTask task) {
        this.tasks.put(task.getName(), task);
    }

    public final void clearTasks() {
        this.tasks.clear();
    }

    public final CSVFormat determineInputFormat(String sourceID) {
        String rawID = this.getProperties().getPropertyString("HEADER:DATASOURCE_rawFile");
        CSVFormat result = sourceID.equals(rawID) ? this.getProperties().getPropertyCSVFormat("HEADER:DATASOURCE_sourceFormat") : this.getProperties().getPropertyCSVFormat("SETUP:CONFIG_csvFormat");
        return result;
    }

    public final CSVFormat determineOutputFormat() {
        return this.getProperties().getPropertyCSVFormat("SETUP:CONFIG_csvFormat");
    }

    public final boolean expectInputHeaders(String filename) {
        if (this.isGenerated(filename)) {
            return true;
        }
        return this.properties.getPropertyBoolean("SETUP:CONFIG_inputHeaders");
    }

    public final DataField findDataField(String name) {
        for (DataField dataField : this.fields) {
            if (!dataField.getName().equalsIgnoreCase(name)) continue;
            return dataField;
        }
        return null;
    }

    public final int findDataFieldIndex(DataField df) {
        for (int result = 0; result < this.fields.length; ++result) {
            if (df != this.fields[result]) continue;
            return result;
        }
        return -1;
    }

    public final AnalystField findNormalizedField(String name, int slice) {
        for (AnalystField field : this.getNormalize().getNormalizedFields()) {
            if (!field.getName().equalsIgnoreCase(name) || field.getTimeSlice() != slice) continue;
            return field;
        }
        return null;
    }

    public final String getBasePath() {
        return this.basePath;
    }

    public final DataField[] getFields() {
        return this.fields;
    }

    public final AnalystNormalize getNormalize() {
        return this.normalize;
    }

    public final int getPrecision() {
        return 10;
    }

    public final ScriptProperties getProperties() {
        return this.properties;
    }

    public final AnalystSegregate getSegregate() {
        return this.segregate;
    }

    public final AnalystTask getTask(String name) {
        if (!this.tasks.containsKey(name)) {
            return null;
        }
        return this.tasks.get(name);
    }

    public final Map<String, AnalystTask> getTasks() {
        return this.tasks;
    }

    public final void init() {
        this.normalize.init(this);
    }

    public final boolean isGenerated(String filename) {
        return this.generated.contains(filename);
    }

    public final void load(InputStream stream) {
        ScriptLoad s = new ScriptLoad(this);
        s.load(stream);
    }

    public final void markGenerated(String filename) {
        this.generated.add(filename);
    }

    public final File resolveFilename(String sourceID) {
        String name = this.getProperties().getFilename(sourceID);
        if (new File(name).getParent() == null && this.basePath != null) {
            return new File(this.basePath, name);
        }
        return new File(name);
    }

    public final void save(OutputStream stream) {
        ScriptSave s = new ScriptSave(this);
        s.save(stream);
    }

    public final void setBasePath(String theBasePath) {
        this.basePath = theBasePath;
    }

    public final void setFields(DataField[] theFields) {
        this.fields = theFields;
    }
}

