/*
 * Decompiled with CFR 0.152.
 */
package org.encog.app.analyst.script.normalize;

import java.util.ArrayList;
import java.util.List;
import org.encog.app.analyst.AnalystError;
import org.encog.app.analyst.missing.DiscardMissing;
import org.encog.app.analyst.missing.HandleMissingValues;
import org.encog.app.analyst.missing.MeanAndModeMissing;
import org.encog.app.analyst.missing.NegateMissing;
import org.encog.app.analyst.script.AnalystClassItem;
import org.encog.app.analyst.script.AnalystScript;
import org.encog.app.analyst.script.DataField;
import org.encog.app.analyst.script.normalize.AnalystField;
import org.encog.util.arrayutil.ClassItem;
import org.encog.util.arrayutil.NormalizationAction;

public class AnalystNormalize {
    private final List<AnalystField> normalizedFields = new ArrayList<AnalystField>();
    private AnalystScript script;

    public AnalystNormalize(AnalystScript theScript) {
        this.script = theScript;
    }

    public final int calculateInputColumns() {
        int result = 0;
        for (AnalystField field : this.normalizedFields) {
            if (!field.isInput()) continue;
            result += field.getColumnsNeeded();
        }
        return result;
    }

    public final int calculateOutputColumns() {
        int result = 0;
        for (AnalystField field : this.normalizedFields) {
            if (!field.isOutput()) continue;
            result += field.getColumnsNeeded();
        }
        return result;
    }

    public final int countActiveFields() {
        int result = 0;
        for (AnalystField field : this.normalizedFields) {
            if (field.getAction() == NormalizationAction.Ignore) continue;
            ++result;
        }
        return result;
    }

    public final List<AnalystField> getNormalizedFields() {
        return this.normalizedFields;
    }

    public final void init(AnalystScript script) {
        if (this.normalizedFields == null) {
            return;
        }
        for (AnalystField norm : this.normalizedFields) {
            DataField f = script.findDataField(norm.getName());
            if (f == null) {
                throw new AnalystError("Normalize specifies unknown field: " + norm.getName());
            }
            if (norm.getAction() == NormalizationAction.Normalize) {
                norm.setActualHigh(f.getMax());
                norm.setActualLow(f.getMin());
            }
            if (norm.getAction() != NormalizationAction.Equilateral && norm.getAction() != NormalizationAction.OneOf && norm.getAction() != NormalizationAction.SingleField) continue;
            int index = 0;
            for (AnalystClassItem item : f.getClassMembers()) {
                norm.getClasses().add(new ClassItem(item.getName(), index++));
            }
        }
    }

    public final String toString() {
        StringBuilder result = new StringBuilder("[");
        result.append(this.getClass().getSimpleName());
        result.append(": ");
        if (this.normalizedFields != null) {
            result.append(this.normalizedFields.toString());
        }
        result.append("]");
        return result.toString();
    }

    public HandleMissingValues getMissingValues() {
        String type = this.script.getProperties().getPropertyString("ML:CONFIG_type");
        if (type.equals("DiscardMissing")) {
            return new DiscardMissing();
        }
        if (type.equals("MeanAndModeMissing")) {
            return new MeanAndModeMissing();
        }
        if (type.equals("NegateMissing")) {
            return new NegateMissing();
        }
        return new DiscardMissing();
    }

    public void setMissingValues(HandleMissingValues missingValues) {
        this.script.getProperties().setProperty("NORMALIZE:CONFIG_missingValues", missingValues.getClass().getSimpleName());
    }
}

