/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.networks.training.genetic;

import org.encog.ml.genetic.genes.DoubleGene;
import org.encog.ml.genetic.genome.BasicGenome;
import org.encog.ml.genetic.genome.Chromosome;
import org.encog.neural.networks.BasicNetwork;
import org.encog.neural.networks.structure.NetworkCODEC;

public class NeuralGenome
extends BasicGenome {
    private static final long serialVersionUID = 1L;
    private final Chromosome networkChromosome;

    public NeuralGenome(BasicNetwork network) {
        this.setOrganism(network);
        this.networkChromosome = new Chromosome();
        int size = network.getStructure().calculateSize();
        for (int i = 0; i < size; ++i) {
            DoubleGene gene = new DoubleGene();
            this.networkChromosome.getGenes().add(gene);
        }
        this.getChromosomes().add(this.networkChromosome);
        this.encode();
    }

    @Override
    public final void decode() {
        double[] net = new double[this.networkChromosome.getGenes().size()];
        for (int i = 0; i < net.length; ++i) {
            DoubleGene gene = (DoubleGene)this.networkChromosome.getGenes().get(i);
            net[i] = gene.getValue();
        }
        NetworkCODEC.arrayToNetwork(net, (BasicNetwork)this.getOrganism());
    }

    @Override
    public final void encode() {
        double[] net = NetworkCODEC.networkToArray((BasicNetwork)this.getOrganism());
        for (int i = 0; i < net.length; ++i) {
            ((DoubleGene)this.networkChromosome.getGene(i)).setValue(net[i]);
        }
    }
}

