/*
 * Decompiled with CFR 0.152.
 */
package org.encog.util;

import java.util.Arrays;
import java.util.Collection;

public final class EngineArray {
    public static double[] arrayCopy(double[] input) {
        double[] result = new double[input.length];
        EngineArray.arrayCopy(input, result);
        return result;
    }

    public static void arrayCopy(double[] src, double[] dst) {
        System.arraycopy(src, 0, dst, 0, src.length);
    }

    public static void arrayCopy(double[] source, float[] target) {
        for (int i = 0; i < source.length; ++i) {
            target[i] = (float)source[i];
        }
    }

    public static void arrayCopy(double[] source, int sourcePos, double[] target, int targetPos, int length) {
        System.arraycopy(source, sourcePos, target, targetPos, length);
    }

    public static double[][] arrayCopy(double[][] source) {
        double[][] result = new double[source.length][source[0].length];
        for (int row = 0; row < source.length; ++row) {
            for (int col = 0; col < source[0].length; ++col) {
                result[row][col] = source[row][col];
            }
        }
        return result;
    }

    public static void arrayCopy(float[] source, double[] target) {
        for (int i = 0; i < source.length; ++i) {
            target[i] = source[i];
        }
    }

    public static int[] arrayCopy(int[] input) {
        int[] result = new int[input.length];
        EngineArray.arrayCopy(input, result);
        return result;
    }

    public static void arrayCopy(int[] src, int[] dst) {
        System.arraycopy(src, 0, dst, 0, src.length);
    }

    public static Double[] doubleToObject(double[] array) {
        Double[] result = new Double[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = new Double(array[i]);
        }
        return result;
    }

    public static void fill(double[] array, double value) {
        Arrays.fill(array, value);
    }

    public static void fill(float[] array, float value) {
        Arrays.fill(array, value);
    }

    public static int findStringInArray(String[] search, String searchFor) {
        for (int i = 0; i < search.length; ++i) {
            if (!search[i].equals(searchFor)) continue;
            return i;
        }
        return -1;
    }

    public static double[] listToDouble(Collection<?> list) {
        double[] result = new double[list.size()];
        int index = 0;
        for (Object obj : list) {
            result[index++] = (Double)obj;
        }
        return result;
    }

    public static double[] objectToDouble(Double[] array) {
        double[] result = new double[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = new Double(array[i]);
        }
        return result;
    }

    public static double vectorProduct(double[] a, double[] b) {
        int length = a.length;
        double value = 0.0;
        for (int i = 0; i < length; ++i) {
            value += a[i] * b[i];
        }
        return value;
    }

    private EngineArray() {
    }

    public static int indexOfLargest(double[] data) {
        int result = -1;
        for (int i = 0; i < data.length; ++i) {
            if (result != -1 && !(data[i] > data[result])) continue;
            result = i;
        }
        return result;
    }

    public static double min(double[] weights) {
        double result = Double.MAX_VALUE;
        for (int i = 0; i < weights.length; ++i) {
            result = Math.min(result, weights[i]);
        }
        return result;
    }

    public static double max(double[] weights) {
        double result = Double.MIN_VALUE;
        for (int i = 0; i < weights.length; ++i) {
            result = Math.max(result, weights[i]);
        }
        return result;
    }

    public static boolean contains(int[] array, int target) {
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != target) continue;
            return true;
        }
        return false;
    }

    public static int maxIndex(double[] data) {
        int result = -1;
        for (int i = 0; i < data.length; ++i) {
            if (result != -1 && !(data[i] > data[result])) continue;
            result = i;
        }
        return result;
    }

    public static int maxIndex(int[] data) {
        int result = -1;
        for (int i = 0; i < data.length; ++i) {
            if (result != -1 && data[i] <= data[result]) continue;
            result = i;
        }
        return result;
    }

    public static int max(int[] data) {
        int result = Integer.MIN_VALUE;
        for (int i = 0; i < data.length; ++i) {
            result = Math.max(result, data[i]);
        }
        return result;
    }

    public static int min(int[] data) {
        int result = Integer.MAX_VALUE;
        for (int i = 0; i < data.length; ++i) {
            result = Math.min(result, data[i]);
        }
        return result;
    }

    public static double mean(int[] data) {
        double result = 0.0;
        for (int i = 0; i < data.length; ++i) {
            result += (double)data[i];
        }
        return result / (double)data.length;
    }

    public static double sdev(int[] data) {
        double avg = EngineArray.mean(data);
        double result = 0.0;
        for (int i = 0; i < data.length; ++i) {
            double diff = (double)data[i] - avg;
            result += diff * diff;
        }
        return Math.sqrt(result / (double)data.length);
    }
}

