/*
 * Decompiled with CFR 0.152.
 */
package org.encog.app.analyst.commands;

import java.io.File;
import org.encog.app.analyst.EncogAnalyst;
import org.encog.app.analyst.commands.Cmd;
import org.encog.app.analyst.csv.AnalystEvaluateCSV;
import org.encog.app.analyst.util.AnalystReportBridge;
import org.encog.ml.MLMethod;
import org.encog.persist.EncogDirectoryPersistence;
import org.encog.util.logging.EncogLogging;

public class CmdEvaluate
extends Cmd {
    public static final String COMMAND_NAME = "EVALUATE";

    public CmdEvaluate(EncogAnalyst theAnalyst) {
        super(theAnalyst);
    }

    @Override
    public final boolean executeCommand(String args) {
        String evalID = this.getProp().getPropertyString("ML:CONFIG_evalFile");
        String resourceID = this.getProp().getPropertyString("ML:CONFIG_machineLearningFile");
        String outputID = this.getProp().getPropertyString("ML:CONFIG_outputFile");
        EncogLogging.log(0, "Beginning evaluate");
        EncogLogging.log(0, "evaluate file:" + evalID);
        EncogLogging.log(0, "resource file:" + resourceID);
        File evalFile = this.getScript().resolveFilename(evalID);
        File resourceFile = this.getScript().resolveFilename(resourceID);
        File outputFile = this.getAnalyst().getScript().resolveFilename(outputID);
        MLMethod method = (MLMethod)EncogDirectoryPersistence.loadObject(resourceFile);
        boolean headers = true;
        AnalystEvaluateCSV eval = new AnalystEvaluateCSV();
        eval.setScript(this.getScript());
        this.getAnalyst().setCurrentQuantTask(eval);
        eval.setReport(new AnalystReportBridge(this.getAnalyst()));
        eval.analyze(this.getAnalyst(), evalFile, true, this.getProp().getPropertyCSVFormat("SETUP:CONFIG_csvFormat"));
        eval.process(outputFile, method);
        this.getAnalyst().setCurrentQuantTask(null);
        return eval.shouldStop();
    }

    @Override
    public final String getName() {
        return COMMAND_NAME;
    }
}

