/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.neat.training;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.encog.mathutil.randomize.RangeRandomizer;
import org.encog.ml.MLMethod;
import org.encog.ml.TrainingImplementationType;
import org.encog.ml.data.MLDataSet;
import org.encog.ml.genetic.GeneticAlgorithm;
import org.encog.ml.genetic.genome.Chromosome;
import org.encog.ml.genetic.genome.Genome;
import org.encog.ml.genetic.genome.GenomeComparator;
import org.encog.ml.genetic.population.Population;
import org.encog.ml.genetic.species.BasicSpecies;
import org.encog.ml.genetic.species.Species;
import org.encog.ml.train.MLTrain;
import org.encog.ml.train.strategy.Strategy;
import org.encog.neural.neat.NEATNetwork;
import org.encog.neural.neat.NEATPopulation;
import org.encog.neural.neat.training.NEATGenome;
import org.encog.neural.neat.training.NEATInnovationList;
import org.encog.neural.neat.training.NEATLinkGene;
import org.encog.neural.neat.training.NEATParent;
import org.encog.neural.networks.training.CalculateScore;
import org.encog.neural.networks.training.TrainingError;
import org.encog.neural.networks.training.genetic.GeneticScoreAdapter;
import org.encog.neural.networks.training.propagation.TrainingContinuation;

public class NEATTraining
extends GeneticAlgorithm
implements MLTrain {
    private double averageFitAdjustment;
    private double bestEverScore;
    private NEATNetwork bestEverNetwork;
    private final int inputCount;
    private final int outputCount;
    private double paramActivationMutationRate = 0.1;
    private double paramChanceAddLink = 0.07;
    private double paramChanceAddNode = 0.04;
    private double paramChanceAddRecurrentLink = 0.05;
    private double paramCompatibilityThreshold = 0.26;
    private double paramCrossoverRate = 0.7;
    private double paramMaxActivationPerturbation = 0.1;
    private int paramMaxNumberOfSpecies = 0;
    private double paramMaxPermittedNeurons = 100.0;
    private double paramMaxWeightPerturbation = 0.5;
    private double paramMutationRate = 0.2;
    private int paramNumAddLinkAttempts = 5;
    private int paramNumGensAllowedNoImprovement = 15;
    private int paramNumTrysToFindLoopedLink = 5;
    private int paramNumTrysToFindOldLink = 5;
    private double paramProbabilityWeightReplaced = 0.1;
    private double totalFitAdjustment;
    private boolean snapshot;
    private int iteration;

    public NEATTraining(CalculateScore calculateScore, int inputCount, int outputCount, int populationSize) {
        this.inputCount = inputCount;
        this.outputCount = outputCount;
        this.setCalculateScore(new GeneticScoreAdapter(calculateScore));
        this.setComparator(new GenomeComparator(this.getCalculateScore()));
        this.setPopulation(new NEATPopulation(inputCount, outputCount, populationSize));
        this.init();
    }

    public NEATTraining(CalculateScore calculateScore, Population population) {
        if (population.size() < 1) {
            throw new TrainingError("Population can not be empty.");
        }
        NEATGenome genome = (NEATGenome)population.getGenomes().get(0);
        this.setCalculateScore(new GeneticScoreAdapter(calculateScore));
        this.setComparator(new GenomeComparator(this.getCalculateScore()));
        this.setPopulation(population);
        this.inputCount = genome.getInputCount();
        this.outputCount = genome.getOutputCount();
        this.init();
    }

    public void addNeuronID(long nodeID, List<Long> vec) {
        for (int i = 0; i < vec.size(); ++i) {
            if (vec.get(i) != nodeID) continue;
            return;
        }
        vec.add(nodeID);
    }

    @Override
    public void addStrategy(Strategy strategy) {
        throw new TrainingError("Strategies are not supported by this training method.");
    }

    public void adjustCompatibilityThreshold() {
        if (this.paramMaxNumberOfSpecies < 1) {
            return;
        }
        double thresholdIncrement = 0.01;
        if (this.getPopulation().getSpecies().size() > this.paramMaxNumberOfSpecies) {
            this.paramCompatibilityThreshold += 0.01;
        } else if (this.getPopulation().getSpecies().size() < 2) {
            this.paramCompatibilityThreshold -= 0.01;
        }
    }

    public void adjustSpeciesScore() {
        for (Species s : this.getPopulation().getSpecies()) {
            for (Genome member : s.getMembers()) {
                double score = member.getScore();
                if (s.getAge() < this.getPopulation().getYoungBonusAgeThreshold()) {
                    score = this.getComparator().applyBonus(score, this.getPopulation().getYoungScoreBonus());
                }
                if (s.getAge() > this.getPopulation().getOldAgeThreshold()) {
                    score = this.getComparator().applyPenalty(score, this.getPopulation().getOldAgePenalty());
                }
                double adjustedScore = score / (double)s.getMembers().size();
                member.setAdjustedScore(adjustedScore);
            }
        }
    }

    @Override
    public boolean canContinue() {
        return false;
    }

    public NEATGenome crossover(NEATGenome mom, NEATGenome dad) {
        NEATParent best = mom.getScore() == dad.getScore() ? (mom.getNumGenes() == dad.getNumGenes() ? (Math.random() > 0.0 ? NEATParent.Mom : NEATParent.Dad) : (mom.getNumGenes() < dad.getNumGenes() ? NEATParent.Mom : NEATParent.Dad)) : (this.getComparator().isBetterThan(mom.getScore(), dad.getScore()) ? NEATParent.Mom : NEATParent.Dad);
        Chromosome babyNeurons = new Chromosome();
        Chromosome babyGenes = new Chromosome();
        ArrayList<Long> vecNeurons = new ArrayList<Long>();
        int curMom = 0;
        int curDad = 0;
        NEATLinkGene selectedGene = null;
        while (curMom < mom.getNumGenes() || curDad < dad.getNumGenes()) {
            NEATLinkGene momGene = curMom < mom.getNumGenes() ? (NEATLinkGene)mom.getLinks().get(curMom) : null;
            NEATLinkGene dadGene = curDad < dad.getNumGenes() ? (NEATLinkGene)dad.getLinks().get(curDad) : null;
            if (momGene == null && dadGene != null) {
                if (best == NEATParent.Dad) {
                    selectedGene = dadGene;
                }
                ++curDad;
            } else if (dadGene == null && momGene != null) {
                if (best == NEATParent.Mom) {
                    selectedGene = momGene;
                }
                ++curMom;
            } else if (momGene.getInnovationId() < dadGene.getInnovationId()) {
                if (best == NEATParent.Mom) {
                    selectedGene = momGene;
                }
                ++curMom;
            } else if (dadGene.getInnovationId() < momGene.getInnovationId()) {
                if (best == NEATParent.Dad) {
                    selectedGene = dadGene;
                }
                ++curDad;
            } else if (dadGene.getInnovationId() == momGene.getInnovationId()) {
                selectedGene = Math.random() < 0.5 ? momGene : dadGene;
                ++curMom;
                ++curDad;
            }
            if (babyGenes.size() == 0) {
                babyGenes.add(selectedGene);
            } else if (((NEATLinkGene)babyGenes.get(babyGenes.size() - 1)).getInnovationId() != selectedGene.getInnovationId()) {
                babyGenes.add(selectedGene);
            }
            this.addNeuronID(selectedGene.getFromNeuronID(), vecNeurons);
            this.addNeuronID(selectedGene.getToNeuronID(), vecNeurons);
        }
        Collections.sort(vecNeurons);
        for (int i = 0; i < vecNeurons.size(); ++i) {
            babyNeurons.add(this.getInnovations().createNeuronFromID((Long)vecNeurons.get(i)));
        }
        NEATGenome babyGenome = new NEATGenome(this.getPopulation().assignGenomeID(), babyNeurons, babyGenes, mom.getInputCount(), mom.getOutputCount());
        babyGenome.setGeneticAlgorithm(this);
        babyGenome.setPopulation(this.getPopulation());
        return babyGenome;
    }

    @Override
    public void finishTraining() {
    }

    @Override
    public double getError() {
        return this.bestEverScore;
    }

    @Override
    public TrainingImplementationType getImplementationType() {
        return TrainingImplementationType.Iterative;
    }

    public NEATInnovationList getInnovations() {
        return (NEATInnovationList)this.getPopulation().getInnovations();
    }

    public int getInputCount() {
        return this.inputCount;
    }

    @Override
    public int getIteration() {
        return this.iteration;
    }

    @Override
    public MLMethod getMethod() {
        return this.bestEverNetwork;
    }

    public int getOutputCount() {
        return this.outputCount;
    }

    public double getParamActivationMutationRate() {
        return this.paramActivationMutationRate;
    }

    public double getParamChanceAddLink() {
        return this.paramChanceAddLink;
    }

    public double getParamChanceAddNode() {
        return this.paramChanceAddNode;
    }

    public double getParamChanceAddRecurrentLink() {
        return this.paramChanceAddRecurrentLink;
    }

    public double getParamCompatibilityThreshold() {
        return this.paramCompatibilityThreshold;
    }

    public double getParamCrossoverRate() {
        return this.paramCrossoverRate;
    }

    public double getParamMaxActivationPerturbation() {
        return this.paramMaxActivationPerturbation;
    }

    public int getParamMaxNumberOfSpecies() {
        return this.paramMaxNumberOfSpecies;
    }

    public double getParamMaxPermittedNeurons() {
        return this.paramMaxPermittedNeurons;
    }

    public double getParamMaxWeightPerturbation() {
        return this.paramMaxWeightPerturbation;
    }

    public double getParamMutationRate() {
        return this.paramMutationRate;
    }

    public int getParamNumAddLinkAttempts() {
        return this.paramNumAddLinkAttempts;
    }

    public int getParamNumGensAllowedNoImprovement() {
        return this.paramNumGensAllowedNoImprovement;
    }

    public int getParamNumTrysToFindLoopedLink() {
        return this.paramNumTrysToFindLoopedLink;
    }

    public int getParamNumTrysToFindOldLink() {
        return this.paramNumTrysToFindOldLink;
    }

    public double getParamProbabilityWeightReplaced() {
        return this.paramProbabilityWeightReplaced;
    }

    @Override
    public List<Strategy> getStrategies() {
        return new ArrayList<Strategy>();
    }

    @Override
    public MLDataSet getTraining() {
        return null;
    }

    private void init() {
        this.bestEverScore = this.getCalculateScore().shouldMinimize() ? Double.MAX_VALUE : Double.MIN_VALUE;
        for (Genome obj : this.getPopulation().getGenomes()) {
            if (!(obj instanceof NEATGenome)) {
                throw new TrainingError("Population can only contain objects of NEATGenome.");
            }
            NEATGenome neat = (NEATGenome)obj;
            if (neat.getInputCount() != this.inputCount || neat.getOutputCount() != this.outputCount) {
                throw new TrainingError("All NEATGenome's must have the same input and output sizes as the base network.");
            }
            neat.setGeneticAlgorithm(this);
        }
        this.getPopulation().claim(this);
        this.resetAndKill();
        this.sortAndRecord();
        this.speciateAndCalculateSpawnLevels();
    }

    public boolean isSnapshot() {
        return this.snapshot;
    }

    @Override
    public boolean isTrainingDone() {
        return false;
    }

    @Override
    public void iteration() {
        ++this.iteration;
        ArrayList<NEATGenome> newPop = new ArrayList<NEATGenome>();
        int numSpawnedSoFar = 0;
        for (Species s : this.getPopulation().getSpecies()) {
            if (numSpawnedSoFar >= this.getPopulation().size()) continue;
            int numToSpawn = (int)Math.round(s.getNumToSpawn());
            boolean bChosenBestYet = false;
            while (numToSpawn-- > 0) {
                NEATGenome baby = null;
                if (!bChosenBestYet) {
                    baby = (NEATGenome)s.getLeader();
                    bChosenBestYet = true;
                } else {
                    if (s.getMembers().size() == 1) {
                        baby = new NEATGenome((NEATGenome)s.chooseParent());
                    } else {
                        NEATGenome g1 = (NEATGenome)s.chooseParent();
                        if (Math.random() < this.paramCrossoverRate) {
                            NEATGenome g2 = (NEATGenome)s.chooseParent();
                            int numAttempts = 5;
                            while (g1.getGenomeID() == g2.getGenomeID() && numAttempts-- > 0) {
                                g2 = (NEATGenome)s.chooseParent();
                            }
                            if (g1.getGenomeID() != g2.getGenomeID()) {
                                baby = this.crossover(g1, g2);
                            }
                        } else {
                            baby = new NEATGenome(g1);
                        }
                    }
                    if (baby != null) {
                        baby.setGenomeID(this.getPopulation().assignGenomeID());
                        if ((double)baby.getNeurons().size() < this.paramMaxPermittedNeurons) {
                            baby.addNeuron(this.paramChanceAddNode, this.paramNumTrysToFindOldLink);
                        }
                        baby.addLink(this.paramChanceAddLink, this.paramChanceAddRecurrentLink, this.paramNumTrysToFindLoopedLink, this.paramNumAddLinkAttempts);
                        baby.mutateWeights(this.paramMutationRate, this.paramProbabilityWeightReplaced, this.paramMaxWeightPerturbation);
                        baby.mutateActivationResponse(this.paramActivationMutationRate, this.paramMaxActivationPerturbation);
                    }
                }
                if (baby == null) continue;
                baby.sortGenes();
                newPop.add(baby);
                if (++numSpawnedSoFar != this.getPopulation().size()) continue;
                numToSpawn = 0;
            }
        }
        while (newPop.size() < this.getPopulation().size()) {
            newPop.add(this.tournamentSelection(this.getPopulation().size() / 5));
        }
        this.getPopulation().clear();
        this.getPopulation().addAll(newPop);
        this.resetAndKill();
        this.sortAndRecord();
        this.speciateAndCalculateSpawnLevels();
    }

    @Override
    public void iteration(int count) {
        for (int i = 0; i < count; ++i) {
            this.iteration();
        }
    }

    @Override
    public TrainingContinuation pause() {
        return null;
    }

    public void resetAndKill() {
        Object[] speciesArray;
        this.totalFitAdjustment = 0.0;
        this.averageFitAdjustment = 0.0;
        for (Object element : speciesArray = this.getPopulation().getSpecies().toArray()) {
            Species s = (Species)element;
            s.purge();
            if (s.getGensNoImprovement() <= this.paramNumGensAllowedNoImprovement || !this.getComparator().isBetterThan(this.bestEverScore, s.getBestScore())) continue;
            this.getPopulation().getSpecies().remove(s);
        }
    }

    @Override
    public void resume(TrainingContinuation state) {
    }

    @Override
    public void setError(double error) {
    }

    @Override
    public void setIteration(int iteration) {
        this.iteration = iteration;
    }

    public void setParamActivationMutationRate(double paramActivationMutationRate) {
        this.paramActivationMutationRate = paramActivationMutationRate;
    }

    public void setParamChanceAddLink(double paramChanceAddLink) {
        this.paramChanceAddLink = paramChanceAddLink;
    }

    public void setParamChanceAddNode(double paramChanceAddNode) {
        this.paramChanceAddNode = paramChanceAddNode;
    }

    public void setParamChanceAddRecurrentLink(double paramChanceAddRecurrentLink) {
        this.paramChanceAddRecurrentLink = paramChanceAddRecurrentLink;
    }

    public void setParamCompatibilityThreshold(double paramCompatibilityThreshold) {
        this.paramCompatibilityThreshold = paramCompatibilityThreshold;
    }

    public void setParamCrossoverRate(double paramCrossoverRate) {
        this.paramCrossoverRate = paramCrossoverRate;
    }

    public void setParamMaxActivationPerturbation(double paramMaxActivationPerturbation) {
        this.paramMaxActivationPerturbation = paramMaxActivationPerturbation;
    }

    public void setParamMaxNumberOfSpecies(int paramMaxNumberOfSpecies) {
        this.paramMaxNumberOfSpecies = paramMaxNumberOfSpecies;
    }

    public void setParamMaxPermittedNeurons(double paramMaxPermittedNeurons) {
        this.paramMaxPermittedNeurons = paramMaxPermittedNeurons;
    }

    public void setParamMaxWeightPerturbation(double paramMaxWeightPerturbation) {
        this.paramMaxWeightPerturbation = paramMaxWeightPerturbation;
    }

    public void setParamMutationRate(double paramMutationRate) {
        this.paramMutationRate = paramMutationRate;
    }

    public void setParamNumAddLinkAttempts(int paramNumAddLinkAttempts) {
        this.paramNumAddLinkAttempts = paramNumAddLinkAttempts;
    }

    public void setParamNumGensAllowedNoImprovement(int paramNumGensAllowedNoImprovement) {
        this.paramNumGensAllowedNoImprovement = paramNumGensAllowedNoImprovement;
    }

    public void setParamNumTrysToFindLoopedLink(int paramNumTrysToFindLoopedLink) {
        this.paramNumTrysToFindLoopedLink = paramNumTrysToFindLoopedLink;
    }

    public void setParamNumTrysToFindOldLink(int paramNumTrysToFindOldLink) {
        this.paramNumTrysToFindOldLink = paramNumTrysToFindOldLink;
    }

    public void setParamProbabilityWeightReplaced(double paramProbabilityWeightReplaced) {
        this.paramProbabilityWeightReplaced = paramProbabilityWeightReplaced;
    }

    public void setSnapshot(boolean snapshot) {
        this.snapshot = snapshot;
    }

    public void sortAndRecord() {
        for (Genome genome : this.getPopulation().getGenomes()) {
            genome.decode();
            this.calculateScore(genome);
        }
        this.getPopulation().sort();
        Genome genome = this.getPopulation().getBest();
        double currentBest = genome.getScore();
        if (this.getComparator().isBetterThan(currentBest, this.bestEverScore)) {
            this.bestEverScore = currentBest;
            this.bestEverNetwork = (NEATNetwork)genome.getOrganism();
        }
        this.bestEverScore = this.getComparator().bestScore(this.getError(), this.bestEverScore);
    }

    public void speciateAndCalculateSpawnLevels() {
        NEATGenome genome;
        this.adjustCompatibilityThreshold();
        for (Genome g : this.getPopulation().getGenomes()) {
            genome = (NEATGenome)g;
            boolean added = false;
            for (Species s : this.getPopulation().getSpecies()) {
                double compatibility = genome.getCompatibilityScore((NEATGenome)s.getLeader());
                if (!(compatibility <= this.paramCompatibilityThreshold)) continue;
                this.addSpeciesMember(s, genome);
                genome.setSpeciesID(s.getSpeciesID());
                added = true;
                break;
            }
            if (added) continue;
            this.getPopulation().getSpecies().add(new BasicSpecies(this.getPopulation(), genome, this.getPopulation().assignSpeciesID()));
        }
        this.adjustSpeciesScore();
        for (Genome g : this.getPopulation().getGenomes()) {
            genome = (NEATGenome)g;
            this.totalFitAdjustment += genome.getAdjustedScore();
        }
        this.averageFitAdjustment = this.totalFitAdjustment / (double)this.getPopulation().size();
        for (Genome g : this.getPopulation().getGenomes()) {
            genome = (NEATGenome)g;
            double toSpawn = genome.getAdjustedScore() / this.averageFitAdjustment;
            genome.setAmountToSpawn(toSpawn);
        }
        for (Species species : this.getPopulation().getSpecies()) {
            species.calculateSpawnAmount();
        }
    }

    public NEATGenome tournamentSelection(int numComparisons) {
        double bestScoreSoFar = 0.0;
        int ChosenOne = 0;
        for (int i = 0; i < numComparisons; ++i) {
            int ThisTry = (int)RangeRandomizer.randomize(0.0, this.getPopulation().size() - 1);
            if (!(this.getPopulation().get(ThisTry).getScore() > bestScoreSoFar)) continue;
            ChosenOne = ThisTry;
            bestScoreSoFar = this.getPopulation().get(ThisTry).getScore();
        }
        return (NEATGenome)this.getPopulation().get(ChosenOne);
    }
}

