/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.pattern;

import org.encog.engine.network.activation.ActivationFunction;
import org.encog.ml.MLMethod;
import org.encog.neural.networks.BasicNetwork;
import org.encog.neural.networks.layers.BasicLayer;
import org.encog.neural.pattern.NeuralNetworkPattern;
import org.encog.neural.pattern.PatternError;

public class ElmanPattern
implements NeuralNetworkPattern {
    private int inputNeurons = -1;
    private int outputNeurons = -1;
    private int hiddenNeurons = -1;
    private ActivationFunction activation;

    @Override
    public final void addHiddenLayer(int count) {
        if (this.hiddenNeurons != -1) {
            throw new PatternError("An Elman neural network should have only one hidden layer.");
        }
        this.hiddenNeurons = count;
    }

    @Override
    public final void clear() {
        this.hiddenNeurons = -1;
    }

    @Override
    public final MLMethod generate() {
        BasicNetwork network = new BasicNetwork();
        BasicLayer input = new BasicLayer(this.activation, true, this.inputNeurons);
        network.addLayer(input);
        BasicLayer hidden = new BasicLayer(this.activation, true, this.hiddenNeurons);
        network.addLayer(hidden);
        network.addLayer(new BasicLayer(null, false, this.outputNeurons));
        input.setContextFedBy(hidden);
        network.getStructure().finalizeStructure();
        network.reset();
        return network;
    }

    @Override
    public final void setActivationFunction(ActivationFunction activation) {
        this.activation = activation;
    }

    @Override
    public final void setInputNeurons(int count) {
        this.inputNeurons = count;
    }

    @Override
    public final void setOutputNeurons(int count) {
        this.outputNeurons = count;
    }
}

