/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.thermal;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import org.encog.neural.thermal.BoltzmannMachine;
import org.encog.persist.EncogFileSection;
import org.encog.persist.EncogPersistor;
import org.encog.persist.EncogReadHelper;
import org.encog.persist.EncogWriteHelper;
import org.encog.util.csv.CSVFormat;
import org.encog.util.csv.NumberList;

public class PersistBoltzmann
implements EncogPersistor {
    @Override
    public final int getFileVersion() {
        return 1;
    }

    @Override
    public final String getPersistClassString() {
        return "BoltzmannMachine";
    }

    @Override
    public final Object read(InputStream is) {
        EncogFileSection section;
        BoltzmannMachine result = new BoltzmannMachine();
        EncogReadHelper in = new EncogReadHelper(is);
        while ((section = in.readNextSection()) != null) {
            Map<String, String> params;
            if (section.getSectionName().equals("BOLTZMANN") && section.getSubSectionName().equals("PARAMS")) {
                params = section.parseParams();
                result.getProperties().putAll(params);
            }
            if (!section.getSectionName().equals("BOLTZMANN") || !section.getSubSectionName().equals("NETWORK")) continue;
            params = section.parseParams();
            result.setWeights(NumberList.fromList(CSVFormat.EG_FORMAT, params.get("weights")));
            result.setCurrentState(NumberList.fromList(CSVFormat.EG_FORMAT, params.get("output")));
            result.setNeuronCount(EncogFileSection.parseInt(params, "neurons"));
            result.setThreshold(NumberList.fromList(CSVFormat.EG_FORMAT, params.get("thresholds")));
            result.setAnnealCycles(EncogFileSection.parseInt(params, "annealCycles"));
            result.setRunCycles(EncogFileSection.parseInt(params, "runCycles"));
            result.setTemperature(EncogFileSection.parseDouble(params, "temperature"));
        }
        return result;
    }

    @Override
    public final void save(OutputStream os, Object obj) {
        EncogWriteHelper out = new EncogWriteHelper(os);
        BoltzmannMachine boltz = (BoltzmannMachine)obj;
        out.addSection("BOLTZMANN");
        out.addSubSection("PARAMS");
        out.addProperties(boltz.getProperties());
        out.addSubSection("NETWORK");
        out.writeProperty("weights", boltz.getWeights());
        out.writeProperty("output", boltz.getCurrentState().getData());
        out.writeProperty("neurons", boltz.getNeuronCount());
        out.writeProperty("thresholds", boltz.getThreshold());
        out.writeProperty("annealCycles", boltz.getAnnealCycles());
        out.writeProperty("runCycles", boltz.getRunCycles());
        out.writeProperty("temperature", boltz.getTemperature());
        out.flush();
    }
}

