/*
 * Decompiled with CFR 0.152.
 */
package org.encog.app.analyst;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import org.encog.app.analyst.AnalystError;
import org.encog.app.analyst.AnalystFileFormat;
import org.encog.app.analyst.AnalystListener;
import org.encog.app.analyst.analyze.PerformAnalysis;
import org.encog.app.analyst.commands.Cmd;
import org.encog.app.analyst.commands.CmdBalance;
import org.encog.app.analyst.commands.CmdCluster;
import org.encog.app.analyst.commands.CmdCreate;
import org.encog.app.analyst.commands.CmdEvaluate;
import org.encog.app.analyst.commands.CmdEvaluateRaw;
import org.encog.app.analyst.commands.CmdGenerate;
import org.encog.app.analyst.commands.CmdNormalize;
import org.encog.app.analyst.commands.CmdRandomize;
import org.encog.app.analyst.commands.CmdReset;
import org.encog.app.analyst.commands.CmdSegregate;
import org.encog.app.analyst.commands.CmdSet;
import org.encog.app.analyst.commands.CmdTrain;
import org.encog.app.analyst.script.AnalystScript;
import org.encog.app.analyst.script.normalize.AnalystField;
import org.encog.app.analyst.script.task.AnalystTask;
import org.encog.app.quant.QuantTask;
import org.encog.ml.MLMethod;
import org.encog.ml.train.MLTrain;
import org.encog.util.Format;
import org.encog.util.logging.EncogLogging;

public class EncogAnalyst {
    public static final String TASK_FULL = "task-full";
    private final AnalystScript script = new AnalystScript();
    private final List<AnalystListener> listeners = new ArrayList<AnalystListener>();
    public static final int UPDATE_TIME = 10;
    private QuantTask currentQuantTask = null;
    private final Map<String, Cmd> commands = new HashMap<String, Cmd>();
    private int maxIteration = -1;
    private Map<String, String> revertData;
    private MLMethod method;

    public EncogAnalyst() {
        this.addCommand(new CmdCreate(this));
        this.addCommand(new CmdEvaluate(this));
        this.addCommand(new CmdEvaluateRaw(this));
        this.addCommand(new CmdGenerate(this));
        this.addCommand(new CmdNormalize(this));
        this.addCommand(new CmdRandomize(this));
        this.addCommand(new CmdSegregate(this));
        this.addCommand(new CmdTrain(this));
        this.addCommand(new CmdBalance(this));
        this.addCommand(new CmdSet(this));
        this.addCommand(new CmdReset(this));
        this.addCommand(new CmdCluster(this));
    }

    public final void addAnalystListener(AnalystListener listener) {
        this.listeners.add(listener);
    }

    public final void addCommand(Cmd cmd) {
        this.commands.put(cmd.getName(), cmd);
    }

    public final void analyze(File file, boolean headers, AnalystFileFormat format) {
        this.script.getProperties().setFilename("FILE_RAW", file.toString());
        this.script.getProperties().setProperty("SETUP:CONFIG_inputHeaders", headers);
        PerformAnalysis a = new PerformAnalysis(this.script, file.toString(), headers, format);
        a.process(this);
    }

    public final int determineInputCount() {
        int result = 0;
        for (AnalystField field : this.script.getNormalize().getNormalizedFields()) {
            if (!field.isInput() || field.isIgnored()) continue;
            result += field.getColumnsNeeded();
        }
        return result;
    }

    public final int determineInputFieldCount() {
        int result = 0;
        for (AnalystField field : this.script.getNormalize().getNormalizedFields()) {
            if (!field.isInput() || field.isIgnored()) continue;
            ++result;
        }
        return result;
    }

    public final int determineOutputCount() {
        int result = 0;
        for (AnalystField field : this.script.getNormalize().getNormalizedFields()) {
            if (!field.isOutput() || field.isIgnored()) continue;
            result += field.getColumnsNeeded();
        }
        return result;
    }

    public final int determineOutputFieldCount() {
        int result = 0;
        for (AnalystField field : this.script.getNormalize().getNormalizedFields()) {
            if (!field.isOutput() || field.isIgnored()) continue;
            ++result;
        }
        return result;
    }

    public final int determineUniqueColumns() {
        HashMap used = new HashMap();
        int result = 0;
        for (AnalystField field : this.script.getNormalize().getNormalizedFields()) {
            String name;
            if (field.isIgnored() || used.containsKey(name = field.getName())) continue;
            result += field.getColumnsNeeded();
            used.put(name, null);
        }
        return result;
    }

    public final int determineUniqueInputFieldCount() {
        HashMap map = new HashMap();
        int result = 0;
        for (AnalystField field : this.script.getNormalize().getNormalizedFields()) {
            if (map.containsKey(field.getName()) || !field.isInput() || field.isIgnored()) continue;
            ++result;
            map.put(field.getName(), null);
        }
        return result;
    }

    public final int determineTotalInputFieldCount() {
        int result = 0;
        for (AnalystField field : this.script.getNormalize().getNormalizedFields()) {
            if (!field.isInput() || field.isIgnored()) continue;
            result += field.getColumnsNeeded();
        }
        return result;
    }

    public final int determineUniqueOutputFieldCount() {
        HashMap map = new HashMap();
        int result = 0;
        for (AnalystField field : this.script.getNormalize().getNormalizedFields()) {
            if (map.containsKey(field.getName())) continue;
            if (field.isOutput() && !field.isIgnored()) {
                ++result;
            }
            map.put(field.getName(), null);
        }
        return result;
    }

    public final void download() {
        URL sourceURL = this.script.getProperties().getPropertyURL("HEADER:DATASOURCE_sourceFile");
        String rawFile = this.script.getProperties().getPropertyFile("HEADER:DATASOURCE_rawFile");
        File rawFilename = this.getScript().resolveFilename(rawFile);
        if (!rawFilename.exists()) {
            this.downloadPage(sourceURL, rawFilename);
        }
    }

    private void downloadPage(URL url, File file) {
        FileOutputStream fos = null;
        InputStream is = null;
        FileInputStream fis = null;
        GZIPInputStream gis = null;
        try {
            int length;
            long size = 0L;
            byte[] buffer = new byte[32768];
            File tempFile = new File(file.getParentFile(), "temp.tmp");
            int lastUpdate = 0;
            fos = new FileOutputStream(tempFile);
            is = url.openStream();
            do {
                if ((length = is.read(buffer)) >= 0) {
                    fos.write(buffer, 0, length);
                    size += (long)length;
                }
                if (lastUpdate > 10) {
                    this.report(0, (int)(size / 0x100000L), "Downloading... " + Format.formatMemory(size));
                    lastUpdate = 0;
                }
                ++lastUpdate;
            } while (length >= 0);
            fos.close();
            fos = null;
            if (url.toString().toLowerCase().endsWith(".gz")) {
                fis = new FileInputStream(tempFile);
                gis = new GZIPInputStream(fis);
                fos = new FileOutputStream(file);
                size = 0L;
                lastUpdate = 0;
                do {
                    if ((length = gis.read(buffer)) >= 0) {
                        fos.write(buffer, 0, length);
                        size += (long)length;
                    }
                    if (lastUpdate > 10) {
                        this.report(0, (int)(size / 0x100000L), "Uncompressing... " + Format.formatMemory(size));
                        lastUpdate = 0;
                    }
                    ++lastUpdate;
                } while (length >= 0);
                tempFile.delete();
            } else {
                file.delete();
                tempFile.renameTo(file);
            }
        }
        catch (IOException e) {
            throw new AnalystError(e);
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {
                    EncogLogging.log(e);
                }
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    EncogLogging.log(e);
                }
            }
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    EncogLogging.log(e);
                }
            }
            if (gis != null) {
                try {
                    gis.close();
                }
                catch (IOException e) {
                    EncogLogging.log(e);
                }
            }
        }
    }

    public final void executeTask(AnalystTask task) {
        int total = task.getLines().size();
        int current = 1;
        for (String line : task.getLines()) {
            String args;
            String command;
            EncogLogging.log(0, "Execute analyst line: " + line);
            this.reportCommandBegin(total, current, line);
            line = line.trim();
            boolean canceled = false;
            String line2 = line.trim();
            int index = line2.indexOf(32);
            if (index != -1) {
                command = line2.substring(0, index).toUpperCase();
                args = line2.substring(index + 1);
            } else {
                command = line2.toUpperCase();
                args = "";
            }
            Cmd cmd = this.commands.get(command);
            if (cmd == null) {
                throw new AnalystError("Unknown Command: " + line);
            }
            canceled = cmd.executeCommand(args);
            this.reportCommandEnd(canceled);
            this.setCurrentQuantTask(null);
            ++current;
            if (!this.shouldStopAll()) continue;
            break;
        }
    }

    public final void executeTask(String name) {
        EncogLogging.log(1, "Analyst execute task:" + name);
        AnalystTask task = this.script.getTask(name);
        if (task == null) {
            throw new AnalystError("Can't find task: " + name);
        }
        this.executeTask(task);
    }

    public final int getLagDepth() {
        int result = 0;
        for (AnalystField field : this.script.getNormalize().getNormalizedFields()) {
            if (field.getTimeSlice() >= 0) continue;
            result = Math.max(result, Math.abs(field.getTimeSlice()));
        }
        return result;
    }

    public final int getLeadDepth() {
        int result = 0;
        for (AnalystField field : this.script.getNormalize().getNormalizedFields()) {
            if (field.getTimeSlice() <= 0) continue;
            result = Math.max(result, field.getTimeSlice());
        }
        return result;
    }

    public final List<AnalystListener> getListeners() {
        return this.listeners;
    }

    public final int getMaxIteration() {
        return this.maxIteration;
    }

    public final Map<String, String> getRevertData() {
        return this.revertData;
    }

    public final AnalystScript getScript() {
        return this.script;
    }

    public final void load(File file) {
        FileInputStream fis = null;
        this.script.setBasePath(file.getParent());
        try {
            fis = new FileInputStream(file);
            this.load(fis);
        }
        catch (IOException ex) {
            throw new AnalystError(ex);
        }
        finally {
            if (fis != null) {
                try {
                    ((InputStream)fis).close();
                }
                catch (IOException e) {
                    throw new AnalystError(e);
                }
            }
        }
    }

    public final void load(InputStream stream) {
        this.script.load(stream);
        this.revertData = this.script.getProperties().prepareRevert();
    }

    public final void load(String filename) {
        this.load(new File(filename));
    }

    public final void removeAnalystListener(AnalystListener listener) {
        this.listeners.remove(listener);
    }

    private void report(int total, int current, String message) {
        for (AnalystListener listener : this.listeners) {
            listener.report(total, current, message);
        }
    }

    private void reportCommandBegin(int total, int current, String name) {
        for (AnalystListener listener : this.listeners) {
            listener.reportCommandBegin(total, current, name);
        }
    }

    private void reportCommandEnd(boolean canceled) {
        for (AnalystListener listener : this.listeners) {
            listener.reportCommandEnd(canceled);
        }
    }

    public final void reportTraining(MLTrain train) {
        for (AnalystListener listener : this.listeners) {
            listener.reportTraining(train);
        }
    }

    public final void reportTrainingBegin() {
        for (AnalystListener listener : this.listeners) {
            listener.reportTrainingBegin();
        }
    }

    public final void reportTrainingEnd() {
        for (AnalystListener listener : this.listeners) {
            listener.reportTrainingEnd();
        }
    }

    public final void save(File file) {
        OutputStream fos = null;
        try {
            this.script.setBasePath(file.getParent());
            fos = new FileOutputStream(file);
            this.save(fos);
        }
        catch (IOException ex) {
            throw new AnalystError(ex);
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {
                    throw new AnalystError(e);
                }
            }
        }
    }

    public final void save(OutputStream stream) {
        this.script.save(stream);
    }

    public final void save(String filename) {
        this.save(new File(filename));
    }

    public final synchronized void setCurrentQuantTask(QuantTask task) {
        this.currentQuantTask = task;
    }

    public final void setMaxIteration(int i) {
        this.maxIteration = i;
    }

    private boolean shouldStopAll() {
        for (AnalystListener listener : this.listeners) {
            if (!listener.shouldShutDown()) continue;
            return true;
        }
        return false;
    }

    public final boolean shouldStopCommand() {
        for (AnalystListener listener : this.listeners) {
            if (!listener.shouldStopCommand()) continue;
            return true;
        }
        return false;
    }

    public final synchronized void stopCurrentTask() {
        if (this.currentQuantTask != null) {
            this.currentQuantTask.requestStop();
        }
    }

    public final boolean isTimeSeries() {
        for (AnalystField field : this.script.getNormalize().getNormalizedFields()) {
            if (field.getTimeSlice() == 0) continue;
            return true;
        }
        return false;
    }

    public MLMethod getMethod() {
        return this.method;
    }

    public void setMethod(MLMethod method) {
        this.method = method;
    }

    public int determineTotalColumns() {
        int result = 0;
        for (AnalystField field : this.script.getNormalize().getNormalizedFields()) {
            if (field.isIgnored()) continue;
            result += field.getColumnsNeeded();
        }
        return result;
    }
}

