/*
 * Decompiled with CFR 0.152.
 */
package org.encog.mathutil.matrices.decomposition;

import org.encog.mathutil.matrices.Matrix;
import org.encog.mathutil.matrices.MatrixError;

public class CholeskyDecomposition {
    private double[][] l;
    private int n;
    private boolean isspd;

    public CholeskyDecomposition(Matrix matrix) {
        double[][] a = matrix.getData();
        this.n = matrix.getRows();
        this.l = new double[this.n][this.n];
        this.isspd = matrix.getCols() == this.n;
        for (int j = 0; j < this.n; ++j) {
            int k;
            double[] lrowj = this.l[j];
            double d = 0.0;
            for (k = 0; k < j; ++k) {
                double[] lrowk = this.l[k];
                double s = 0.0;
                for (int i = 0; i < k; ++i) {
                    s += lrowk[i] * lrowj[i];
                }
                lrowj[k] = s = (a[j][k] - s) / this.l[k][k];
                d += s * s;
                this.isspd &= a[k][j] == a[j][k];
            }
            this.isspd &= (d = a[j][j] - d) > 0.0;
            this.l[j][j] = Math.sqrt(Math.max(d, 0.0));
            for (k = j + 1; k < this.n; ++k) {
                this.l[j][k] = 0.0;
            }
        }
    }

    public final boolean isSPD() {
        return this.isspd;
    }

    public final Matrix getL() {
        return new Matrix(this.l);
    }

    public final Matrix solve(Matrix b) {
        int i;
        int j;
        int k;
        if (b.getRows() != this.n) {
            throw new MatrixError("Matrix row dimensions must agree.");
        }
        if (!this.isspd) {
            throw new RuntimeException("Matrix is not symmetric positive definite.");
        }
        double[][] x = b.getArrayCopy();
        int nx = b.getCols();
        for (k = 0; k < this.n; ++k) {
            j = 0;
            while (j < nx) {
                for (i = 0; i < k; ++i) {
                    double[] dArray = x[k];
                    int n = j;
                    dArray[n] = dArray[n] - x[i][j] * this.l[k][i];
                }
                double[] dArray = x[k];
                int n = j++;
                dArray[n] = dArray[n] / this.l[k][k];
            }
        }
        for (k = this.n - 1; k >= 0; --k) {
            j = 0;
            while (j < nx) {
                for (i = k + 1; i < this.n; ++i) {
                    double[] dArray = x[k];
                    int n = j;
                    dArray[n] = dArray[n] - x[i][j] * this.l[i][k];
                }
                double[] dArray = x[k];
                int n = j++;
                dArray[n] = dArray[n] / this.l[k][k];
            }
        }
        return new Matrix(x);
    }
}

