/*
 * Decompiled with CFR 0.152.
 */
package org.encog.ml.factory.train;

import java.util.Map;
import org.encog.EncogError;
import org.encog.ml.MLMethod;
import org.encog.ml.data.MLDataSet;
import org.encog.ml.factory.parse.ArchitectureParse;
import org.encog.ml.train.MLTrain;
import org.encog.neural.networks.BasicNetwork;
import org.encog.neural.networks.training.lma.LevenbergMarquardtTraining;
import org.encog.util.ParamsHolder;

public class LMAFactory {
    public final MLTrain create(MLMethod method, MLDataSet training, String argsStr) {
        if (!(method instanceof BasicNetwork)) {
            throw new EncogError("LMA training cannot be used on a method of type: " + method.getClass().getName());
        }
        Map<String, String> args = ArchitectureParse.parseParams(argsStr);
        ParamsHolder holder = new ParamsHolder(args);
        LevenbergMarquardtTraining result = new LevenbergMarquardtTraining((BasicNetwork)method, training);
        return result;
    }
}

