/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.rbf;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.encog.engine.network.activation.ActivationFunction;
import org.encog.mathutil.rbf.RadialBasisFunction;
import org.encog.neural.flat.FlatNetworkRBF;
import org.encog.neural.rbf.RBFNetwork;
import org.encog.persist.EncogFileSection;
import org.encog.persist.EncogPersistor;
import org.encog.persist.EncogReadHelper;
import org.encog.persist.EncogWriteHelper;
import org.encog.persist.PersistError;
import org.encog.util.csv.CSVFormat;

public class PersistRBFNetwork
implements EncogPersistor {
    @Override
    public final int getFileVersion() {
        return 1;
    }

    @Override
    public final String getPersistClassString() {
        return "RBFNetwork";
    }

    @Override
    public final Object read(InputStream is) {
        EncogFileSection section;
        RBFNetwork result = new RBFNetwork();
        FlatNetworkRBF flat = (FlatNetworkRBF)result.getFlat();
        EncogReadHelper in = new EncogReadHelper(is);
        while ((section = in.readNextSection()) != null) {
            Map<String, String> params;
            if (section.getSectionName().equals("RBF-NETWORK") && section.getSubSectionName().equals("PARAMS")) {
                params = section.parseParams();
                result.getProperties().putAll(params);
            }
            if (section.getSectionName().equals("RBF-NETWORK") && section.getSubSectionName().equals("NETWORK")) {
                params = section.parseParams();
                flat.setBeginTraining(EncogFileSection.parseInt(params, "beginTraining"));
                flat.setConnectionLimit(EncogFileSection.parseDouble(params, "connectionLimit"));
                flat.setContextTargetOffset(EncogFileSection.parseIntArray(params, "contextTargetOffset"));
                flat.setContextTargetSize(EncogFileSection.parseIntArray(params, "contextTargetSize"));
                flat.setEndTraining(EncogFileSection.parseInt(params, "endTraining"));
                flat.setHasContext(EncogFileSection.parseBoolean(params, "hasContext"));
                flat.setInputCount(EncogFileSection.parseInt(params, "inputCount"));
                flat.setLayerCounts(EncogFileSection.parseIntArray(params, "layerCounts"));
                flat.setLayerFeedCounts(EncogFileSection.parseIntArray(params, "layerFeedCounts"));
                flat.setLayerContextCount(EncogFileSection.parseIntArray(params, "layerContextCount"));
                flat.setLayerIndex(EncogFileSection.parseIntArray(params, "layerIndex"));
                flat.setLayerOutput(EncogFileSection.parseDoubleArray(params, "output"));
                flat.setLayerSums(new double[flat.getLayerOutput().length]);
                flat.setOutputCount(EncogFileSection.parseInt(params, "outputCount"));
                flat.setWeightIndex(EncogFileSection.parseIntArray(params, "weightIndex"));
                flat.setWeights(EncogFileSection.parseDoubleArray(params, "weights"));
                flat.setBiasActivation(EncogFileSection.parseDoubleArray(params, "biasActivation"));
                continue;
            }
            if (section.getSectionName().equals("RBF-NETWORK") && section.getSubSectionName().equals("ACTIVATION")) {
                int index = 0;
                flat.setActivationFunctions(new ActivationFunction[flat.getLayerCounts().length]);
                for (String line : section.getLines()) {
                    ActivationFunction af = null;
                    List<String> cols = EncogFileSection.splitColumns(line);
                    String name = "org.encog.engine.network.activation." + cols.get(0);
                    try {
                        Class<?> clazz = Class.forName(name);
                        af = (ActivationFunction)clazz.newInstance();
                    }
                    catch (ClassNotFoundException e) {
                        throw new PersistError(e);
                    }
                    catch (InstantiationException e) {
                        throw new PersistError(e);
                    }
                    catch (IllegalAccessException e) {
                        throw new PersistError(e);
                    }
                    for (int i = 0; i < af.getParamNames().length; ++i) {
                        af.setParam(i, CSVFormat.EG_FORMAT.parse(cols.get(i + 1)));
                    }
                    flat.getActivationFunctions()[index++] = af;
                }
                continue;
            }
            if (!section.getSectionName().equals("RBF-NETWORK") || !section.getSubSectionName().equals("RBF")) continue;
            int index = 0;
            int hiddenCount = flat.getLayerCounts()[1];
            int inputCount = flat.getLayerCounts()[2];
            flat.setRBF(new RadialBasisFunction[hiddenCount]);
            for (String line : section.getLines()) {
                RadialBasisFunction rbf = null;
                List<String> cols = EncogFileSection.splitColumns(line);
                String name = "org.encog.mathutil.rbf." + cols.get(0);
                try {
                    Class<?> clazz = Class.forName(name);
                    rbf = (RadialBasisFunction)clazz.newInstance();
                }
                catch (ClassNotFoundException e) {
                    throw new PersistError(e);
                }
                catch (InstantiationException e) {
                    throw new PersistError(e);
                }
                catch (IllegalAccessException e) {
                    throw new PersistError(e);
                }
                rbf.setWidth(CSVFormat.EG_FORMAT.parse(cols.get(1)));
                rbf.setPeak(CSVFormat.EG_FORMAT.parse(cols.get(2)));
                rbf.setCenters(new double[inputCount]);
                for (int i = 0; i < inputCount; ++i) {
                    rbf.getCenters()[i] = CSVFormat.EG_FORMAT.parse(cols.get(i + 3));
                }
                flat.getRBF()[index++] = rbf;
            }
        }
        return result;
    }

    @Override
    public final void save(OutputStream os, Object obj) {
        int i;
        EncogWriteHelper out = new EncogWriteHelper(os);
        RBFNetwork net = (RBFNetwork)obj;
        FlatNetworkRBF flat = (FlatNetworkRBF)net.getFlat();
        out.addSection("RBF-NETWORK");
        out.addSubSection("PARAMS");
        out.addProperties(net.getProperties());
        out.addSubSection("NETWORK");
        out.writeProperty("beginTraining", flat.getBeginTraining());
        out.writeProperty("connectionLimit", flat.getConnectionLimit());
        out.writeProperty("contextTargetOffset", flat.getContextTargetOffset());
        out.writeProperty("contextTargetSize", flat.getContextTargetSize());
        out.writeProperty("endTraining", flat.getEndTraining());
        out.writeProperty("hasContext", flat.getHasContext());
        out.writeProperty("inputCount", flat.getInputCount());
        out.writeProperty("layerCounts", flat.getLayerCounts());
        out.writeProperty("layerFeedCounts", flat.getLayerFeedCounts());
        out.writeProperty("layerContextCount", flat.getLayerContextCount());
        out.writeProperty("layerIndex", flat.getLayerIndex());
        out.writeProperty("output", flat.getLayerOutput());
        out.writeProperty("outputCount", flat.getOutputCount());
        out.writeProperty("weightIndex", flat.getWeightIndex());
        out.writeProperty("weights", flat.getWeights());
        out.writeProperty("biasActivation", flat.getBiasActivation());
        out.addSubSection("ACTIVATION");
        for (ActivationFunction activationFunction : flat.getActivationFunctions()) {
            out.addColumn(activationFunction.getClass().getSimpleName());
            for (i = 0; i < activationFunction.getParams().length; ++i) {
                out.addColumn(activationFunction.getParams()[i]);
            }
            out.writeLine();
        }
        out.addSubSection("RBF");
        for (Serializable serializable : flat.getRBF()) {
            out.addColumn(serializable.getClass().getSimpleName());
            out.addColumn(serializable.getWidth());
            out.addColumn(serializable.getPeak());
            for (i = 0; i < serializable.getCenters().length; ++i) {
                out.addColumn(serializable.getCenters()[i]);
            }
            out.writeLine();
        }
        out.flush();
    }
}

