/*
 * Decompiled with CFR 0.152.
 */
package org.encog.app.analyst.wizard;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.encog.app.analyst.AnalystError;
import org.encog.app.analyst.AnalystFileFormat;
import org.encog.app.analyst.AnalystGoal;
import org.encog.app.analyst.EncogAnalyst;
import org.encog.app.analyst.missing.DiscardMissing;
import org.encog.app.analyst.missing.HandleMissingValues;
import org.encog.app.analyst.script.AnalystScript;
import org.encog.app.analyst.script.DataField;
import org.encog.app.analyst.script.normalize.AnalystField;
import org.encog.app.analyst.script.prop.ScriptProperties;
import org.encog.app.analyst.script.segregate.AnalystSegregateTarget;
import org.encog.app.analyst.script.task.AnalystTask;
import org.encog.app.analyst.wizard.NormalizeRange;
import org.encog.app.analyst.wizard.WizardMethodType;
import org.encog.util.arrayutil.NormalizationAction;
import org.encog.util.file.FileUtil;

public class AnalystWizard {
    public static final int DEFAULT_TRAIN_PERCENT = 75;
    public static final int DEFAULT_EVAL_PERCENT = 25;
    public static final double DEFAULT_TRAIN_ERROR = 0.05;
    public static final String FILE_RAW = "FILE_RAW";
    public static final String FILE_NORMALIZE = "FILE_NORMALIZE";
    public static final String FILE_RANDOM = "FILE_RANDOMIZE";
    public static final String FILE_TRAIN = "FILE_TRAIN";
    public static final String FILE_EVAL = "FILE_EVAL";
    public static final String FILE_EVAL_NORM = "FILE_EVAL_NORM";
    public static final String FILE_TRAINSET = "FILE_TRAINSET";
    public static final String FILE_ML = "FILE_ML";
    public static final String FILE_OUTPUT = "FILE_OUTPUT";
    public static final String FILE_BALANCE = "FILE_BALANCE";
    public static final String FILE_CLUSTER = "FILE_CLUSTER";
    private String filenameRaw;
    private String filenameNorm;
    private String filenameRandom;
    private String filenameTrain;
    private String filenameEval;
    private String filenameEvalNorm;
    private String filenameTrainSet;
    private String filenameML;
    private String filenameOutput;
    private String filenameBalance;
    private String filenameCluster;
    private final AnalystScript script;
    private final EncogAnalyst analyst;
    private WizardMethodType methodType;
    private boolean directClassification = false;
    private String targetField;
    private AnalystGoal goal;
    private int lagWindowSize;
    private int leadWindowSize;
    private boolean includeTargetField;
    private boolean timeSeries;
    private boolean taskSegregate = true;
    private boolean taskRandomize = true;
    private boolean taskNormalize = true;
    private boolean taskBalance = false;
    private boolean taskCluster = true;
    private NormalizeRange range = NormalizeRange.NegOne2One;
    private HandleMissingValues missing = new DiscardMissing();
    private AnalystFileFormat format;

    public AnalystWizard(EncogAnalyst theAnalyst) {
        this.analyst = theAnalyst;
        this.script = this.analyst.getScript();
        this.methodType = WizardMethodType.FeedForward;
        this.targetField = "";
        this.goal = AnalystGoal.Classification;
        this.leadWindowSize = 0;
        this.lagWindowSize = 0;
        this.includeTargetField = false;
    }

    private String createSet(String setTarget, String setSource) {
        StringBuilder result = new StringBuilder();
        result.append("set ");
        result.append(ScriptProperties.toDots(setTarget));
        result.append("=\"");
        result.append(setSource);
        result.append("\"");
        return result.toString();
    }

    private void determineClassification() {
        this.directClassification = false;
        if (this.methodType == WizardMethodType.SVM || this.methodType == WizardMethodType.SOM) {
            this.directClassification = true;
        }
    }

    private void determineTargetField() {
        List<AnalystField> fields = this.script.getNormalize().getNormalizedFields();
        if (this.targetField.trim().length() == 0) {
            DataField df;
            boolean success = false;
            if (this.goal == AnalystGoal.Classification) {
                for (AnalystField field : fields) {
                    df = this.script.findDataField(field.getName());
                    if (!field.getAction().isClassify() || !df.isClass()) continue;
                    this.targetField = field.getName();
                    success = true;
                }
            } else {
                for (AnalystField field : fields) {
                    df = this.script.findDataField(field.getName());
                    if (df.isClass() || !df.isReal() && !df.isInteger()) continue;
                    this.targetField = field.getName();
                    success = true;
                }
            }
            if (!success) {
                throw new AnalystError("Can't determine target field automatically, please specify one.\nThis can also happen if you specified the wrong file format.");
            }
        } else if (this.script.findDataField(this.targetField) == null) {
            throw new AnalystError("Invalid target field: " + this.targetField);
        }
        this.script.getProperties().setProperty("DATA:CONFIG_goal", this.goal);
        if (!this.timeSeries && this.taskBalance) {
            this.script.getProperties().setProperty("BALANCE:CONFIG_balanceField", this.targetField);
            DataField field = this.analyst.getScript().findDataField(this.targetField);
            if (field != null && field.isClass()) {
                int countPer = field.getMinClassCount();
                this.script.getProperties().setProperty("BALANCE:CONFIG_countPer", countPer);
            }
        }
        AnalystField af = null;
        for (AnalystField field : this.analyst.getScript().getNormalize().getNormalizedFields()) {
            if (field.getAction() == NormalizationAction.Ignore || !field.getName().equalsIgnoreCase(this.targetField) || af != null && af.getTimeSlice() >= field.getTimeSlice()) continue;
            af = field;
        }
        if (af != null) {
            af.setOutput(true);
        }
        if (this.taskCluster) {
            if (this.targetField.length() == 0 || this.goal != AnalystGoal.Classification) {
                this.script.getProperties().setProperty("CLUSTER:CONFIG_clusters", 2);
            } else {
                DataField tf = this.script.findDataField(this.targetField);
                this.script.getProperties().setProperty("CLUSTER:CONFIG_clusters", tf.getClassMembers().size());
            }
        }
    }

    private void expandTimeSlices() {
        AnalystField newField;
        int i;
        List<AnalystField> oldList = this.script.getNormalize().getNormalizedFields();
        ArrayList<AnalystField> newList = new ArrayList<AnalystField>();
        for (AnalystField field : oldList) {
            if (!field.isIgnored()) {
                if (!this.includeTargetField && !field.isInput()) continue;
                for (i = 0; i < this.lagWindowSize; ++i) {
                    newField = new AnalystField(field);
                    newField.setTimeSlice(-i);
                    newField.setOutput(false);
                    newList.add(newField);
                }
                continue;
            }
            newList.add(field);
        }
        for (AnalystField field : oldList) {
            if (field.isIgnored() || !field.isOutput()) continue;
            for (i = 1; i <= this.leadWindowSize; ++i) {
                newField = new AnalystField(field);
                newField.setTimeSlice(i);
                newList.add(newField);
            }
        }
        for (AnalystField field : oldList) {
            if (!field.isIgnored()) continue;
            newList.add(field);
        }
        oldList.clear();
        oldList.addAll(newList);
    }

    private void generateFeedForward(int inputColumns, int outputColumns) {
        int hidden = (int)((double)inputColumns * 1.5);
        this.script.getProperties().setProperty("ML:CONFIG_type", "feedforward");
        if (this.range == NormalizeRange.NegOne2One) {
            this.script.getProperties().setProperty("ML:CONFIG_architecture", "?:B->TANH->" + hidden + ":B->TANH->?");
        } else {
            this.script.getProperties().setProperty("ML:CONFIG_architecture", "?:B->SIGMOID->" + hidden + ":B->SIGMOID->?");
        }
        this.script.getProperties().setProperty("ML:TRAIN_type", "rprop");
        this.script.getProperties().setProperty("ML:TRAIN_targetError", 0.05);
    }

    private void generateFilenames(File rawFile) {
        this.filenameRaw = rawFile.getName();
        this.filenameNorm = FileUtil.addFilenameBase(rawFile, "_norm").getName();
        this.filenameRandom = FileUtil.addFilenameBase(rawFile, "_random").getName();
        this.filenameTrain = FileUtil.addFilenameBase(rawFile, "_train").getName();
        this.filenameEval = FileUtil.addFilenameBase(rawFile, "_eval").getName();
        this.filenameEvalNorm = FileUtil.addFilenameBase(rawFile, "_eval_norm").getName();
        this.filenameTrainSet = FileUtil.forceExtension(this.filenameTrain, "egb");
        this.filenameML = FileUtil.forceExtension(this.filenameTrain, "eg");
        this.filenameOutput = FileUtil.addFilenameBase(rawFile, "_output").getName();
        this.filenameBalance = FileUtil.addFilenameBase(rawFile, "_balance").getName();
        this.filenameCluster = FileUtil.addFilenameBase(rawFile, "_cluster").getName();
        ScriptProperties p = this.script.getProperties();
        p.setFilename(FILE_RAW, this.filenameRaw);
        if (this.taskNormalize) {
            p.setFilename(FILE_NORMALIZE, this.filenameNorm);
        }
        if (this.taskRandomize) {
            p.setFilename(FILE_RANDOM, this.filenameRandom);
        }
        if (this.taskCluster) {
            p.setFilename(FILE_CLUSTER, this.filenameCluster);
        }
        if (this.taskSegregate) {
            p.setFilename(FILE_TRAIN, this.filenameTrain);
            p.setFilename(FILE_EVAL, this.filenameEval);
            p.setFilename(FILE_EVAL_NORM, this.filenameEvalNorm);
        }
        if (this.taskBalance) {
            p.setFilename(FILE_BALANCE, this.filenameBalance);
        }
        p.setFilename(FILE_TRAINSET, this.filenameTrainSet);
        p.setFilename(FILE_ML, this.filenameML);
        p.setFilename(FILE_OUTPUT, this.filenameOutput);
    }

    private void generateGenerate() {
        this.determineTargetField();
        if (this.targetField == null) {
            throw new AnalystError("Failed to find normalized version of target field: " + this.targetField);
        }
        int inputColumns = this.script.getNormalize().calculateInputColumns();
        int idealColumns = this.script.getNormalize().calculateOutputColumns();
        switch (this.methodType) {
            case FeedForward: {
                this.generateFeedForward(inputColumns, idealColumns);
                break;
            }
            case SVM: {
                this.generateSVM(inputColumns, idealColumns);
                break;
            }
            case RBF: {
                this.generateRBF(inputColumns, idealColumns);
                break;
            }
            case SOM: {
                this.generateSOM(inputColumns);
                break;
            }
            default: {
                throw new AnalystError("Unknown method type");
            }
        }
    }

    private void generateNormalizedFields() {
        List<AnalystField> norm = this.script.getNormalize().getNormalizedFields();
        norm.clear();
        DataField[] dataFields = this.script.getFields();
        for (int i = 0; i < this.script.getFields().length; ++i) {
            NormalizationAction action;
            boolean isLast;
            DataField f = dataFields[i];
            boolean bl = isLast = i == this.script.getFields().length - 1;
            if ((f.isInteger() || f.isReal()) && !f.isClass()) {
                action = NormalizationAction.Normalize;
                AnalystField af = this.range == NormalizeRange.NegOne2One ? new AnalystField(f.getName(), action, 1.0, -1.0) : new AnalystField(f.getName(), action, 1.0, 0.0);
                norm.add(af);
                af.setActualHigh(f.getMax());
                af.setActualLow(f.getMin());
                continue;
            }
            if (f.isClass()) {
                action = isLast && this.directClassification ? NormalizationAction.SingleField : (f.getClassMembers().size() > 2 ? NormalizationAction.Equilateral : NormalizationAction.OneOf);
                if (this.range == NormalizeRange.NegOne2One) {
                    norm.add(new AnalystField(f.getName(), action, 1.0, -1.0));
                    continue;
                }
                norm.add(new AnalystField(f.getName(), action, 1.0, 0.0));
                continue;
            }
            action = NormalizationAction.Ignore;
            norm.add(new AnalystField(action, f.getName()));
        }
        this.script.getNormalize().init(this.script);
    }

    private void generateRBF(int inputColumns, int outputColumns) {
        int hidden = (int)((double)inputColumns * 1.5);
        this.script.getProperties().setProperty("ML:CONFIG_type", "rbfnetwork");
        this.script.getProperties().setProperty("ML:CONFIG_architecture", "?->GAUSSIAN(c=" + hidden + ")->?");
        if (outputColumns > 1) {
            this.script.getProperties().setProperty("ML:TRAIN_type", "rprop");
        } else {
            this.script.getProperties().setProperty("ML:TRAIN_type", "svd");
        }
        this.script.getProperties().setProperty("ML:TRAIN_type", 0.05);
    }

    private void generateSegregate() {
        if (this.taskSegregate) {
            AnalystSegregateTarget[] array = new AnalystSegregateTarget[]{new AnalystSegregateTarget(FILE_TRAIN, 75), new AnalystSegregateTarget(FILE_EVAL, 25)};
            this.script.getSegregate().setSegregateTargets(array);
        } else {
            AnalystSegregateTarget[] array = new AnalystSegregateTarget[]{};
            this.script.getSegregate().setSegregateTargets(array);
        }
    }

    private void generateSettings() {
        String target = FILE_RAW;
        this.script.getProperties().setProperty("HEADER:DATASOURCE_rawFile", target);
        if (!this.timeSeries && this.taskRandomize) {
            this.script.getProperties().setProperty("RANDOMIZE:CONFIG_sourceFile", FILE_RAW);
            target = FILE_RANDOM;
            this.script.getProperties().setProperty("RANDOMIZE:CONFIG_targetFile", target);
        }
        if (!this.timeSeries && this.taskBalance) {
            this.script.getProperties().setProperty("BALANCE:CONFIG_sourceFile", target);
            target = FILE_BALANCE;
            this.script.getProperties().setProperty("BALANCE:CONFIG_targetFile", target);
        }
        if (this.taskSegregate) {
            this.script.getProperties().setProperty("SEGREGATE:CONFIG_sourceFile", target);
            target = FILE_TRAIN;
        }
        if (this.taskNormalize) {
            this.script.getProperties().setProperty("NORMALIZE:CONFIG_sourceFile", target);
            target = FILE_NORMALIZE;
            this.script.getProperties().setProperty("NORMALIZE:CONFIG_targetFile", target);
            this.script.getNormalize().setMissingValues(this.missing);
        }
        String evalSource = this.taskSegregate ? FILE_EVAL : target;
        if (this.taskCluster) {
            this.script.getProperties().setProperty("CLUSTER:CONFIG_sourceFile", evalSource);
            this.script.getProperties().setProperty("CLUSTER:CONFIG_targetFile", FILE_CLUSTER);
            this.script.getProperties().setProperty("CLUSTER:CONFIG_type", "kmeans");
        }
        this.script.getProperties().setProperty("GENERATE:CONFIG_sourceFile", target);
        this.script.getProperties().setProperty("GENERATE:CONFIG_targetFile", FILE_TRAINSET);
        this.script.getProperties().setProperty("ML:CONFIG_trainingFile", FILE_TRAINSET);
        this.script.getProperties().setProperty("ML:CONFIG_machineLearningFile", FILE_ML);
        this.script.getProperties().setProperty("ML:CONFIG_outputFile", FILE_OUTPUT);
        this.script.getProperties().setProperty("ML:CONFIG_evalFile", evalSource);
        this.script.getProperties().setProperty("SETUP:CONFIG_csvFormat", this.format);
    }

    private void generateSOM(int inputColumns) {
        this.script.getProperties().setProperty("ML:CONFIG_type", "som");
        this.script.getProperties().setProperty("ML:CONFIG_architecture", "?->?");
        this.script.getProperties().setProperty("ML:TRAIN_type", "som-neighborhood");
        this.script.getProperties().setProperty("ML:TRAIN_arguments", "ITERATIONS=1000,NEIGHBORHOOD=rbf1d,RBF_TYPE=gaussian");
        this.script.getProperties().setProperty("ML:TRAIN_targetError", 0.05);
    }

    private void generateSVM(int inputColumns, int outputColumns) {
        StringBuilder arch = new StringBuilder();
        arch.append("?->");
        if (this.goal == AnalystGoal.Classification) {
            arch.append("C");
        } else {
            arch.append("R");
        }
        arch.append("(type=new,kernel=rbf)->?");
        this.script.getProperties().setProperty("ML:CONFIG_type", "svm");
        this.script.getProperties().setProperty("ML:CONFIG_architecture", arch.toString());
        this.script.getProperties().setProperty("ML:TRAIN_type", "svm-search");
        this.script.getProperties().setProperty("ML:TRAIN_targetError", 0.05);
    }

    private void generateTasks() {
        AnalystTask task1 = new AnalystTask("task-full");
        if (!this.timeSeries && this.taskRandomize) {
            task1.getLines().add("randomize");
        }
        if (!this.timeSeries && this.taskBalance) {
            task1.getLines().add("balance");
        }
        if (this.taskSegregate) {
            task1.getLines().add("segregate");
        }
        if (this.taskNormalize) {
            task1.getLines().add("normalize");
        }
        task1.getLines().add("generate");
        task1.getLines().add("create");
        task1.getLines().add("train");
        task1.getLines().add("evaluate");
        AnalystTask task2 = new AnalystTask("task-generate");
        if (!this.timeSeries && this.taskRandomize) {
            task2.getLines().add("randomize");
        }
        if (this.taskSegregate) {
            task2.getLines().add("segregate");
        }
        if (this.taskNormalize) {
            task2.getLines().add("normalize");
        }
        task2.getLines().add("generate");
        AnalystTask task3 = new AnalystTask("task-evaluate-raw");
        task3.getLines().add(this.createSet("ML:CONFIG_evalFile", FILE_EVAL_NORM));
        task3.getLines().add(this.createSet("NORMALIZE:CONFIG_sourceFile", FILE_EVAL));
        task3.getLines().add(this.createSet("NORMALIZE:CONFIG_targetFile", FILE_EVAL_NORM));
        task3.getLines().add("normalize");
        task3.getLines().add("evaluate-raw");
        AnalystTask task4 = new AnalystTask("task-create");
        task4.getLines().add("create");
        AnalystTask task5 = new AnalystTask("task-train");
        task5.getLines().add("train");
        AnalystTask task6 = new AnalystTask("task-evaluate");
        task6.getLines().add("evaluate");
        AnalystTask task7 = new AnalystTask("task-cluster");
        task7.getLines().add("cluster");
        this.script.addTask(task1);
        this.script.addTask(task2);
        this.script.addTask(task3);
        this.script.addTask(task4);
        this.script.addTask(task5);
        this.script.addTask(task6);
        this.script.addTask(task7);
    }

    public final AnalystGoal getGoal() {
        return this.goal;
    }

    public final int getLagWindowSize() {
        return this.lagWindowSize;
    }

    public final int getLeadWindowSize() {
        return this.leadWindowSize;
    }

    public final WizardMethodType getMethodType() {
        return this.methodType;
    }

    public final NormalizeRange getRange() {
        return this.range;
    }

    public final String getTargetField() {
        return this.targetField;
    }

    public final boolean isIncludeTargetField() {
        return this.includeTargetField;
    }

    public final boolean isTaskBalance() {
        return this.taskBalance;
    }

    public final boolean isTaskCluster() {
        return this.taskCluster;
    }

    public final boolean isTaskNormalize() {
        return this.taskNormalize;
    }

    public final boolean isTaskRandomize() {
        return this.taskRandomize;
    }

    public final boolean isTaskSegregate() {
        return this.taskSegregate;
    }

    public final void reanalyze() {
        String rawID = this.script.getProperties().getPropertyFile("HEADER:DATASOURCE_rawFile");
        File rawFilename = this.analyst.getScript().resolveFilename(rawID);
        this.analyst.analyze(rawFilename, this.script.getProperties().getPropertyBoolean("SETUP:CONFIG_inputHeaders"), this.script.getProperties().getPropertyFormat("SETUP:CONFIG_csvFormat"));
    }

    public final void setGoal(AnalystGoal theGoal) {
        this.goal = theGoal;
    }

    public final void setIncludeTargetField(boolean theIncludeTargetField) {
        this.includeTargetField = theIncludeTargetField;
    }

    public final void setLagWindowSize(int theLagWindowSize) {
        this.lagWindowSize = theLagWindowSize;
    }

    public final void setLeadWindowSize(int theLeadWindowSize) {
        this.leadWindowSize = theLeadWindowSize;
    }

    public final void setMethodType(WizardMethodType theMethodType) {
        this.methodType = theMethodType;
    }

    public final void setRange(NormalizeRange theRange) {
        this.range = theRange;
    }

    public final void setTargetField(String theTargetField) {
        this.targetField = theTargetField;
    }

    public final void setTaskBalance(boolean theTaskBalance) {
        this.taskBalance = theTaskBalance;
    }

    public final void setTaskCluster(boolean theTaskCluster) {
        this.taskCluster = theTaskCluster;
    }

    public final void setTaskNormalize(boolean theTaskNormalize) {
        this.taskNormalize = theTaskNormalize;
    }

    public final void setTaskRandomize(boolean theTaskRandomize) {
        this.taskRandomize = theTaskRandomize;
    }

    public final void setTaskSegregate(boolean theTaskSegregate) {
        this.taskSegregate = theTaskSegregate;
    }

    public final void wizard(File analyzeFile, boolean b, AnalystFileFormat format) {
        this.script.getProperties().setProperty("HEADER:DATASOURCE_sourceHeaders", b);
        this.script.getProperties().setProperty("HEADER:DATASOURCE_rawFile", analyzeFile);
        this.timeSeries = this.lagWindowSize > 0 || this.leadWindowSize > 0;
        this.format = format;
        this.determineClassification();
        this.generateFilenames(analyzeFile);
        this.generateSettings();
        this.analyst.analyze(analyzeFile, b, format);
        this.generateNormalizedFields();
        this.generateSegregate();
        this.generateGenerate();
        this.generateTasks();
        if (this.timeSeries && this.lagWindowSize > 0 && this.leadWindowSize > 0) {
            this.expandTimeSlices();
        }
    }

    public final void wizard(URL url, File saveFile, File analyzeFile, boolean b, AnalystFileFormat format) {
        this.script.setBasePath(saveFile.getParent());
        this.script.getProperties().setProperty("HEADER:DATASOURCE_sourceFile", url);
        this.script.getProperties().setProperty("HEADER:DATASOURCE_sourceHeaders", b);
        this.script.getProperties().setProperty("HEADER:DATASOURCE_rawFile", analyzeFile);
        this.format = format;
        this.generateFilenames(analyzeFile);
        this.generateSettings();
        this.analyst.download();
        this.wizard(analyzeFile, b, format);
    }

    public HandleMissingValues getMissing() {
        return this.missing;
    }

    public void setMissing(HandleMissingValues missing) {
        this.missing = missing;
    }
}

