/*
 * Decompiled with CFR 0.152.
 */
package org.encog.ml.genetic.population;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.encog.ml.genetic.GeneticAlgorithm;
import org.encog.ml.genetic.genome.Genome;
import org.encog.ml.genetic.innovation.InnovationList;
import org.encog.ml.genetic.population.Population;
import org.encog.ml.genetic.species.Species;
import org.encog.util.identity.BasicGenerateID;
import org.encog.util.identity.GenerateID;

public class BasicPopulation
implements Population {
    public static final double DEFAULT_OLD_AGE_PENALTY = 0.3;
    public static final int DEFAULT_OLD_AGE_THRESHOLD = 50;
    public static final double DEFAULT_SURVIVAL_RATE = 0.2;
    public static final double DEFAULT_YOUTH_BONUS = 0.3;
    public static final int DEFAULT_YOUTH_THRESHOLD = 10;
    private static final long serialVersionUID = 1L;
    private final GenerateID geneIDGenerate = new BasicGenerateID();
    private final GenerateID genomeIDGenerate = new BasicGenerateID();
    private final List<Genome> genomes = new ArrayList<Genome>();
    private final GenerateID innovationIDGenerate = new BasicGenerateID();
    private InnovationList innovations;
    private double oldAgePenalty = 0.3;
    private int oldAgeThreshold = 50;
    private int populationSize;
    private final List<Species> species = new ArrayList<Species>();
    private final GenerateID speciesIDGenerate = new BasicGenerateID();
    private double survivalRate = 0.2;
    private int youngBonusAgeThreshold = 10;
    private double youngScoreBonus = 0.3;
    private String name;

    public BasicPopulation() {
        this.populationSize = 0;
    }

    public BasicPopulation(int thePopulationSize) {
        this.populationSize = thePopulationSize;
    }

    @Override
    public final void add(Genome genome) {
        this.genomes.add(genome);
        genome.setPopulation(this);
    }

    @Override
    public final void addAll(List<? extends Genome> newPop) {
        this.genomes.addAll(newPop);
    }

    @Override
    public final long assignGeneID() {
        return this.geneIDGenerate.generate();
    }

    @Override
    public final long assignGenomeID() {
        return this.genomeIDGenerate.generate();
    }

    @Override
    public final long assignInnovationID() {
        return this.innovationIDGenerate.generate();
    }

    @Override
    public final long assignSpeciesID() {
        return this.speciesIDGenerate.generate();
    }

    @Override
    public final void claim(GeneticAlgorithm ga) {
        for (Genome genome : this.genomes) {
            genome.setGeneticAlgorithm(ga);
        }
    }

    @Override
    public final void clear() {
        this.genomes.clear();
    }

    @Override
    public final Genome get(int i) {
        return this.genomes.get(i);
    }

    @Override
    public final Genome getBest() {
        if (this.genomes.size() == 0) {
            return null;
        }
        return this.genomes.get(0);
    }

    public final GenerateID getGeneIDGenerate() {
        return this.geneIDGenerate;
    }

    public final GenerateID getGenomeIDGenerate() {
        return this.genomeIDGenerate;
    }

    @Override
    public final List<Genome> getGenomes() {
        return this.genomes;
    }

    public final GenerateID getInnovationIDGenerate() {
        return this.innovationIDGenerate;
    }

    @Override
    public final InnovationList getInnovations() {
        return this.innovations;
    }

    public final String getName() {
        return this.name;
    }

    @Override
    public final double getOldAgePenalty() {
        return this.oldAgePenalty;
    }

    @Override
    public final int getOldAgeThreshold() {
        return this.oldAgeThreshold;
    }

    @Override
    public final int getPopulationSize() {
        return this.populationSize;
    }

    @Override
    public final List<Species> getSpecies() {
        return this.species;
    }

    public final GenerateID getSpeciesIDGenerate() {
        return this.speciesIDGenerate;
    }

    @Override
    public final double getSurvivalRate() {
        return this.survivalRate;
    }

    @Override
    public final int getYoungBonusAgeThreshold() {
        return this.youngBonusAgeThreshold;
    }

    @Override
    public final double getYoungScoreBonus() {
        return this.youngScoreBonus;
    }

    @Override
    public final void setInnovations(InnovationList theInnovations) {
        this.innovations = theInnovations;
    }

    public final void setName(String theName) {
        this.name = theName;
    }

    @Override
    public final void setOldAgePenalty(double theOldAgePenalty) {
        this.oldAgePenalty = theOldAgePenalty;
    }

    @Override
    public final void setOldAgeThreshold(int theOldAgeThreshold) {
        this.oldAgeThreshold = theOldAgeThreshold;
    }

    @Override
    public final void setPopulationSize(int thePopulationSize) {
        this.populationSize = thePopulationSize;
    }

    @Override
    public final void setSurvivalRate(double theSurvivalRate) {
        this.survivalRate = theSurvivalRate;
    }

    @Override
    public final void setYoungBonusAgeThreshhold(int theYoungBonusAgeThreshold) {
        this.youngBonusAgeThreshold = theYoungBonusAgeThreshold;
    }

    public final void setYoungBonusAgeThreshold(int theYoungBonusAgeThreshold) {
        this.youngBonusAgeThreshold = theYoungBonusAgeThreshold;
    }

    @Override
    public final void setYoungScoreBonus(double theYoungScoreBonus) {
        this.youngScoreBonus = theYoungScoreBonus;
    }

    @Override
    public final int size() {
        return this.genomes.size();
    }

    @Override
    public final void sort() {
        Collections.sort(this.genomes);
    }
}

